/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.CacheManager;
import javax.cache.CacheManagerFactory;
import javax.cache.CachingShutdownException;
import javax.cache.OptionalFeature;
import javax.cache.spi.AnnotationProvider;
import javax.cache.spi.CachingProvider;

public final class Caching {
    private static final Logger log = Logger.getLogger(Caching.class.getName());
    public static final String DEFAULT_CACHE_MANAGER_NAME = "__default__";
    private static final WeakHashMap<ClassLoader, CachingSingleton> _cacheMap = new WeakHashMap();
    private static final ClassLoader _systemClassLoader;

    private Caching() {
    }

    public static CacheManagerFactory getCacheManagerFactory() {
        return Caching.getCachingSingleton().getFactory();
    }

    public static CacheManager getCacheManager() {
        return Caching.getCacheManager(DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader) {
        return Caching.getCacheManager(classLoader, DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(String name) {
        return Caching.getCacheManagerFactory().getCacheManager(name);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader, String name) {
        return Caching.getCacheManagerFactory().getCacheManager(classLoader, name);
    }

    public static void close() throws CachingShutdownException {
        Caching.getCacheManagerFactory().close();
    }

    public static void close(ClassLoader classLoader) throws CachingShutdownException {
        Caching.getCacheManagerFactory().close(classLoader);
    }

    public static void close(ClassLoader classLoader, String name) throws CachingShutdownException {
        Caching.getCacheManagerFactory().close(classLoader, name);
    }

    public static boolean isSupported(OptionalFeature feature) {
        return Caching.getCachingSingleton().getProvider().isSupported(feature);
    }

    public static boolean isAnnotationsSupported() {
        return Caching.getCachingSingleton().isAnnotationsSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachingSingleton getCachingSingleton() {
        CachingSingleton caching = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = _systemClassLoader;
        }
        WeakHashMap<ClassLoader, CachingSingleton> weakHashMap = _cacheMap;
        synchronized (weakHashMap) {
            caching = _cacheMap.get(loader);
            if (caching == null) {
                caching = new CachingSingleton(loader);
                _cacheMap.put(loader, caching);
            }
        }
        return caching;
    }

    static {
        ClassLoader systemClassLoader = null;
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        _systemClassLoader = systemClassLoader;
    }

    private static final class CachingSingleton {
        private WeakReference<ClassLoader> _loaderRef;
        private SoftReference<CachingProvider> _providerRef;
        private SoftReference<AnnotationProvider> _annProviderRef;

        CachingSingleton(ClassLoader loader) {
            this._loaderRef = new WeakReference<ClassLoader>(loader);
        }

        CacheManagerFactory getFactory() {
            return this.getProvider().getCacheManagerFactory();
        }

        public boolean isAnnotationsSupported() {
            return this.getAnnProvider() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized CachingProvider getProvider() {
            CachingProvider provider = null;
            if (this._providerRef != null) {
                provider = this._providerRef.get();
            }
            if (provider == null) {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader((ClassLoader)this._loaderRef.get());
                    ServiceLoader<CachingProvider> serviceLoader = ServiceLoader.load(CachingProvider.class);
                    Iterator<CachingProvider> iter = serviceLoader.iterator();
                    provider = iter.hasNext() ? iter.next() : null;
                }
                finally {
                    thread.setContextClassLoader(oldLoader);
                }
                if (provider == null) {
                    throw new IllegalStateException("Cannot find a CachingProvider: " + this._loaderRef.get());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Caching: using provider " + provider);
                }
                this._providerRef = new SoftReference<CachingProvider>(provider);
            }
            return provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized AnnotationProvider getAnnProvider() {
            AnnotationProvider provider = null;
            if (this._annProviderRef != null) {
                provider = this._annProviderRef.get();
            }
            if (provider == null) {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader((ClassLoader)this._loaderRef.get());
                    ServiceLoader<AnnotationProvider> serviceLoader = ServiceLoader.load(AnnotationProvider.class);
                    Iterator<AnnotationProvider> iter = serviceLoader.iterator();
                    provider = iter.hasNext() ? iter.next() : null;
                }
                finally {
                    thread.setContextClassLoader(oldLoader);
                }
                if (provider == null) {
                    return null;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Caching: using provider " + provider);
                }
                this._annProviderRef = new SoftReference<AnnotationProvider>(provider);
            }
            return provider;
        }
    }
}

