/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.el.ArrayELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListELResolver
extends ELResolver {
    private static final Logger log = Logger.getLogger(ListELResolver.class.getName());
    private final boolean _isReadOnly;

    public ListELResolver() {
        this._isReadOnly = false;
    }

    public ListELResolver(boolean isReadOnly) {
        this._isReadOnly = true;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        if (base instanceof List) {
            return Object.class;
        }
        return null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base instanceof List) {
            context.setPropertyResolved(true);
            return null;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof List) {
            context.setPropertyResolved(true);
            int index = ArrayELResolver.getIndex(property);
            if (index < 0 || ((List)base).size() <= index) {
                throw new PropertyNotFoundException("list index '" + index + "' is invalid");
            }
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base instanceof List) {
            List list = (List)base;
            context.setPropertyResolved(true);
            int index = ArrayELResolver.getIndex(property);
            if (0 <= index && index < list.size()) {
                return list.get(index);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof List) {
            context.setPropertyResolved(true);
            int index = ArrayELResolver.getIndex(property);
            if (index < 0 || index >= ((List)base).size()) {
                throw new PropertyNotFoundException("list index '" + index + "' is invalid");
            }
            return this._isReadOnly;
        }
        return false;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof List) {
            List list = (List)base;
            context.setPropertyResolved(true);
            int index = ArrayELResolver.getIndex(property);
            if (this._isReadOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            if (index < 0 || list.size() < index) {
                throw new PropertyNotFoundException("list index '" + index + "' is invalid");
            }
            list.set(index, value);
        }
    }
}

