/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import javax.el.ELContext;
import javax.el.ValueExpression;

public final class IndexedValueExpression
extends ValueExpression {
    protected final Integer i;
    protected final ValueExpression orig;

    public IndexedValueExpression(ValueExpression orig, int i) {
        this.orig = orig;
        this.i = i;
    }

    public String getExpressionString() {
        return this.orig.getExpressionString() + "[" + this.i + "]";
    }

    public Class getExpectedType() {
        return Object.class;
    }

    public Class getType(ELContext context) {
        Object value = this.getValue(context);
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public Object getValue(ELContext context) {
        Object base = this.orig.getValue(context);
        return context.getELResolver().getValue(context, base, this.i);
    }

    public void setValue(ELContext context, Object value) {
        Object base = this.orig.getValue(context);
        context.getELResolver().setValue(context, base, this.i, value);
    }

    public int hashCode() {
        return 65521 * this.orig.hashCode() + this.i.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexedValueExpression)) {
            return false;
        }
        IndexedValueExpression expr = (IndexedValueExpression)obj;
        return this.orig.equals(expr.orig) && this.i.equals(expr.i);
    }
}

