/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PermittedTaglibsTLV
extends TagLibraryValidator {
    private HashSet<String> _permitted;

    public ValidationMessage[] validate(String prefix, String uri, PageData data) {
        Map<String, Object> init = this.getInitParameters();
        String permitted = (String)init.get("permittedTaglibs");
        if (permitted == null || "".equals(permitted)) {
            return null;
        }
        this._permitted = new HashSet();
        this._permitted.add("http://java.sun.com/JSP/Page");
        this._permitted.add(uri);
        String[] values = permitted.split("[ \t\n\r]+");
        for (int i = 0; i < values.length; ++i) {
            String permittedUri = values[i].trim();
            if ("".equals(permittedUri)) continue;
            this._permitted.add(permittedUri);
        }
        try {
            InputStream is = data.getInputStream();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            return new ValidationMessage[]{new ValidationMessage("", e.getMessage())};
        }
        return null;
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (uri != null && !"".equals(uri) && !PermittedTaglibsTLV.this._permitted.contains(uri)) {
                throw new SAXException(uri + " is not a permitted tag library");
            }
        }
    }
}

