/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.NullMemoryIO;
import com.kenai.jaffl.provider.jffi.BoundedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.DirectMemoryIO;
import com.kenai.jaffl.provider.jffi.JFFIPointer;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    static final Pointer newPointer(long ptr) {
        return ptr != 0L ? new DirectMemoryIO(ptr) : null;
    }

    static final MemoryIO newMemoryIO(long ptr) {
        return ptr != 0L ? new DirectMemoryIO(ptr) : NullMemoryIO.INSTANCE;
    }

    static final MemoryIO newMemoryIO(long ptr, long size2) {
        return ptr != 0L ? new BoundedDirectMemoryIO(new DirectMemoryIO(ptr), 0L, size2) : NullMemoryIO.INSTANCE;
    }

    static final long getAddress(MemoryIO ptr) {
        if (ptr == null) {
            return 0L;
        }
        if (ptr instanceof JFFIPointer) {
            return ((JFFIPointer)ptr).address;
        }
        if (ptr instanceof DirectMemoryIO) {
            return ((DirectMemoryIO)ptr).address;
        }
        throw new IllegalArgumentException("attempted to get address of non-direct memory. " + ptr.getClass());
    }
}

