/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;

public class Action {
    private String _description;
    private ExecutionType _executionType;
    private String _name;
    private int _priority;
    private String _script;
    private ScriptLanguage _scriptLanguage;
    private String _scriptRequiredContexts;

    public Action(String name, String description, String executionType, String script, String scriptLanguage, String scriptRequiredContexts, int priority) {
        this._name = name;
        this._description = description;
        this._executionType = Validator.isNotNull((String)executionType) ? ExecutionType.parse(executionType) : ExecutionType.ON_TIMER;
        this._script = script;
        this._scriptLanguage = ScriptLanguage.parse(scriptLanguage);
        this._scriptRequiredContexts = scriptRequiredContexts;
        this._priority = priority;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action action = (Action)obj;
        if (Validator.equals((Object)this._name, (Object)action._name)) {
            return true;
        }
        return true;
    }

    public String getDescription() {
        return this._description;
    }

    public ExecutionType getExecutionType() {
        return this._executionType;
    }

    public String getName() {
        return this._name;
    }

    public int getPriority() {
        return this._priority;
    }

    public String getScript() {
        return this._script;
    }

    public ScriptLanguage getScriptLanguage() {
        return this._scriptLanguage;
    }

    public String getScriptRequiredContexts() {
        return this._scriptRequiredContexts;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

