/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.ActionAware;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.NotificationAware;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Node
implements ActionAware,
NotificationAware {
    private Set<Action> _actions;
    private String _description;
    private Set<Transition> _incomingTransitions = new HashSet<Transition>();
    private String _metadata;
    private String _name;
    private NodeType _nodeType;
    private Set<Notification> _notifications;
    private Map<String, Transition> _outgoingTransitions = new HashMap<String, Transition>();
    private Set<Timer> _timers;

    public Node(NodeType nodeType, String name, String description) {
        this._nodeType = nodeType;
        this._name = name;
        this._description = description;
    }

    public void addIncomingTransition(Transition transition) {
        this._incomingTransitions.add(transition);
    }

    public void addOutgoingTransition(Transition transition) {
        this._outgoingTransitions.put(transition.getName(), transition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node node = (Node)obj;
        return Validator.equals((Object)this._name, (Object)node._name);
    }

    @Override
    public Set<Action> getActions() {
        if (this._actions == null) {
            return Collections.emptySet();
        }
        return this._actions;
    }

    public String getDescription() {
        return this._description;
    }

    public Set<Transition> getIncomingTransitions() {
        return this._incomingTransitions;
    }

    public int getIncomingTransitionsCount() {
        return this._incomingTransitions.size();
    }

    public String getMetadata() {
        return this._metadata;
    }

    public String getName() {
        return this._name;
    }

    public NodeType getNodeType() {
        return this._nodeType;
    }

    @Override
    public Set<Notification> getNotifications() {
        if (this._notifications == null) {
            return Collections.emptySet();
        }
        return this._notifications;
    }

    public Map<String, Transition> getOutgoingTransitions() {
        return this._outgoingTransitions;
    }

    public int getOutgoingTransitionsCount() {
        return this._outgoingTransitions.size();
    }

    public List<Transition> getOutgoingTransitionsList() {
        return ListUtil.fromCollection(this._outgoingTransitions.values());
    }

    public Set<Timer> getTimers() {
        if (this._timers == null) {
            return Collections.emptySet();
        }
        return this._timers;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    public void setActions(Set<Action> actions) {
        this._actions = actions;
    }

    public void setMetadata(String metadata) {
        this._metadata = metadata;
    }

    @Override
    public void setNotifications(Set<Notification> notifications) {
        this._notifications = notifications;
    }

    public void setTimers(Set<Timer> timers) {
        this._timers = timers;
    }
}

