/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.NotificationType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.TemplateLanguage;
import java.util.HashSet;
import java.util.Set;

public class Notification {
    private String _description;
    private ExecutionType _executionType;
    private String _name;
    private Set<NotificationType> _notificationTypes = new HashSet<NotificationType>();
    private Set<Recipient> _recipients = new HashSet<Recipient>();
    private String _template;
    private TemplateLanguage _templateLanguage;

    public Notification(String name, String description, String executionType, String template, String templateLanguage) {
        this._name = name;
        this._description = description;
        this._executionType = Validator.isNotNull((String)executionType) ? ExecutionType.parse(executionType) : ExecutionType.ON_TIMER;
        this._template = template;
        this._templateLanguage = TemplateLanguage.parse(templateLanguage);
    }

    public void addNotificationType(String notificationType) {
        this._notificationTypes.add(NotificationType.parse(notificationType));
    }

    public void addRecipients(Recipient recipient) {
        this._recipients.add(recipient);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification notification = (Notification)obj;
        if (Validator.equals((Object)this._name, (Object)notification._name)) {
            return true;
        }
        return true;
    }

    public String getDescription() {
        return this._description;
    }

    public ExecutionType getExecutionType() {
        return this._executionType;
    }

    public String getName() {
        return this._name;
    }

    public Set<NotificationType> getNotificationTypes() {
        return this._notificationTypes;
    }

    public Set<Recipient> getRecipients() {
        return this._recipients;
    }

    public String getTemplate() {
        return this._template;
    }

    public TemplateLanguage getTemplateLanguage() {
        return this._templateLanguage;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

