/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.thread;

import com.caucho.admin.thread.AbstractThreadActivityReport;
import com.caucho.admin.thread.ThreadActivityCode;
import com.caucho.admin.thread.ThreadActivityGroup;
import com.caucho.admin.thread.ThreadSnapshot;
import com.caucho.admin.thread.filter.AcceptThreadFilter;
import com.caucho.admin.thread.filter.AnyThreadFilter;
import com.caucho.admin.thread.filter.BlockedThreadFilter;
import com.caucho.admin.thread.filter.CauchoThreadFilter;
import com.caucho.admin.thread.filter.IdlePoolFilter;
import com.caucho.admin.thread.filter.NativeThreadFilter;
import com.caucho.admin.thread.filter.PortThreadFilter;
import com.caucho.admin.thread.filter.RunningThreadFilter;
import com.caucho.admin.thread.filter.ThreadSnapshotFilter;
import com.caucho.admin.thread.filter.WaitingThreadFilter;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.server.cluster.ServletService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinThreadActivityReport
extends AbstractThreadActivityReport {
    private final Map<ThreadSnapshotFilter, ThreadActivityCode> _filters = new LinkedHashMap<ThreadSnapshotFilter, ThreadActivityCode>();
    private Map<Character, String> _key = new HashMap<Character, String>();

    public ResinThreadActivityReport() {
        this._filters.put(new AcceptThreadFilter(), ThreadActivityCode.ACCEPT);
        this._filters.put(new IdlePoolFilter(), ThreadActivityCode.IDLE);
        this._filters.put(new RunningThreadFilter(), ThreadActivityCode.RUNNING);
        this._filters.put(new BlockedThreadFilter(), ThreadActivityCode.BLOCKED);
        this._filters.put(new NativeThreadFilter(), ThreadActivityCode.NATIVE);
        this._filters.put(new WaitingThreadFilter(), ThreadActivityCode.WAITING);
        for (ThreadActivityCode code : ThreadActivityCode.values()) {
            this._key.put(Character.valueOf(code.getChar()), code.toString());
        }
        this._key = Collections.unmodifiableMap(this._key);
    }

    @Override
    public Map<Character, String> getScoreboardKey() {
        return this._key;
    }

    @Override
    protected boolean assignActivityCode(ThreadSnapshot threadSnapshot) {
        for (Map.Entry<ThreadSnapshotFilter, ThreadActivityCode> entry : this._filters.entrySet()) {
            if (!entry.getKey().isMatch(threadSnapshot)) continue;
            threadSnapshot.setCode(entry.getValue().getChar());
            return true;
        }
        return false;
    }

    @Override
    protected ThreadActivityGroup[] createGroups() {
        PortMXBean[] ports;
        ServerMXBean serverAdmin;
        ArrayList<ThreadActivityGroup> groups = new ArrayList<ThreadActivityGroup>();
        ServletService servletService = ServletService.getCurrent();
        if (servletService != null && (serverAdmin = servletService.getAdmin()) != null && (ports = serverAdmin.getPorts()) != null && ports.length > 0) {
            for (PortMXBean port : ports) {
                String portName = (port.getAddress() == null ? "*" : port.getAddress()) + ":" + port.getPort();
                String groupName = "Port " + portName + " Threads";
                PortThreadFilter filter = new PortThreadFilter(portName);
                ThreadActivityGroup group = new ThreadActivityGroup(groupName, filter);
                groups.add(group);
            }
        }
        CauchoThreadFilter cauchoFilter = new CauchoThreadFilter();
        groups.add(new ThreadActivityGroup("Resin Threads", cauchoFilter));
        AnyThreadFilter miscFilter = new AnyThreadFilter();
        groups.add(new ThreadActivityGroup("Other Threads", miscFilter));
        ThreadActivityGroup[] array = new ThreadActivityGroup[groups.size()];
        groups.toArray(array);
        return array;
    }
}

