/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractConfigIntrospector;
import com.caucho.amber.cfg.AbstractEnhancedConfig;
import com.caucho.amber.cfg.AbstractListenerConfig;
import com.caucho.amber.cfg.AmberConfigManager;
import com.caucho.amber.cfg.AttributeOverrideConfig;
import com.caucho.amber.cfg.AttributesConfig;
import com.caucho.amber.cfg.BasicConfig;
import com.caucho.amber.cfg.ColumnConfig;
import com.caucho.amber.cfg.ColumnResultConfig;
import com.caucho.amber.cfg.Completion;
import com.caucho.amber.cfg.CompletionImpl;
import com.caucho.amber.cfg.ElementCollectionConfig;
import com.caucho.amber.cfg.EmbeddableConfig;
import com.caucho.amber.cfg.EmbeddedIdConfig;
import com.caucho.amber.cfg.EntityConfig;
import com.caucho.amber.cfg.EntityListenerConfig;
import com.caucho.amber.cfg.EntityListenersConfig;
import com.caucho.amber.cfg.EntityMappingsConfig;
import com.caucho.amber.cfg.EntityResultConfig;
import com.caucho.amber.cfg.FieldResultConfig;
import com.caucho.amber.cfg.GeneratedValueConfig;
import com.caucho.amber.cfg.IdConfig;
import com.caucho.amber.cfg.ManyToManyConfig;
import com.caucho.amber.cfg.ManyToOneConfig;
import com.caucho.amber.cfg.MappedSuperclassConfig;
import com.caucho.amber.cfg.NamedNativeQueryConfig;
import com.caucho.amber.cfg.NamedQueryConfig;
import com.caucho.amber.cfg.OneToManyConfig;
import com.caucho.amber.cfg.OneToOneConfig;
import com.caucho.amber.cfg.PersistenceUnitDefaultsConfig;
import com.caucho.amber.cfg.PersistenceUnitMetaDataConfig;
import com.caucho.amber.cfg.PrimaryKeyJoinColumnConfig;
import com.caucho.amber.cfg.SqlResultSetMappingConfig;
import com.caucho.amber.cfg.VersionConfig;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CompositeId;
import com.caucho.amber.field.EmbeddedIdField;
import com.caucho.amber.field.EmbeddedSubField;
import com.caucho.amber.field.EntityEmbeddedField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.field.VersionField;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.idgen.SequenceIdGenerator;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.GeneratorTableType;
import com.caucho.amber.type.ListenerType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EntityResult;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FieldResult;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfigIntrospector
extends AbstractConfigIntrospector {
    private static final Logger log = Logger.getLogger(BaseConfigIntrospector.class.getName());
    private static final L10N L = new L10N(BaseConfigIntrospector.class);
    private static final Class[] _annTypes = new Class[]{Basic.class, Column.class, javax.persistence.Id.class, ElementCollection.class, EmbeddedId.class, ManyToOne.class, OneToMany.class, OneToOne.class, ManyToMany.class, Version.class, Transient.class};
    final AmberConfigManager _configManager;
    final AmberPersistenceUnit _persistenceUnit;
    ArrayList<Completion> _linkCompletions = new ArrayList();
    ArrayList<Completion> _depCompletions = new ArrayList();
    HashMap<String, EmbeddableConfig> _embeddableConfigMap = new HashMap();
    ArrayList<EntityMappingsConfig> _entityMappingsList;

    public BaseConfigIntrospector(AmberConfigManager manager) {
        this._configManager = manager;
        this._persistenceUnit = manager.getPersistenceUnit();
    }

    public void setEntityMappingsList(ArrayList<EntityMappingsConfig> entityMappingsList) {
        this._entityMappingsList = entityMappingsList;
    }

    public EntityConfig getEntityConfig(String className) {
        if (this._entityMappingsList == null) {
            return null;
        }
        for (EntityMappingsConfig entityMappings : this._entityMappingsList) {
            EntityConfig entityConfig;
            HashMap<String, EntityConfig> entityMap = entityMappings.getEntityMap();
            if (entityMap == null || (entityConfig = entityMap.get(className)) == null) continue;
            return entityConfig;
        }
        return null;
    }

    public MappedSuperclassConfig getMappedSuperclassConfig(String className) {
        if (this._entityMappingsList == null) {
            return null;
        }
        for (EntityMappingsConfig entityMappings : this._entityMappingsList) {
            MappedSuperclassConfig superclassConfig;
            HashMap<String, MappedSuperclassConfig> superclassMap = entityMappings.getMappedSuperclassMap();
            if (superclassMap == null || (superclassConfig = superclassMap.get(className)) == null) continue;
            return superclassConfig;
        }
        return null;
    }

    public void initMetaData(ArrayList<EntityMappingsConfig> entityMappingsList, AmberPersistenceUnit persistenceUnit) throws ConfigException {
        EntityMappingsConfig entityMappings;
        PersistenceUnitMetaDataConfig metaData = null;
        Iterator<EntityMappingsConfig> i$ = entityMappingsList.iterator();
        while (i$.hasNext() && (metaData = (entityMappings = i$.next()).getPersistenceUnitMetaData()) == null) {
        }
        if (metaData == null) {
            return;
        }
        PersistenceUnitDefaultsConfig defaults = metaData.getPersistenceUnitDefaults();
        if (defaults == null) {
            return;
        }
        EntityListenersConfig entityListeners = defaults.getEntityListeners();
        if (entityListeners == null) {
            return;
        }
        ArrayList<EntityListenerConfig> listeners = entityListeners.getEntityListeners();
        for (EntityListenerConfig listener : listeners) {
            this.introspectDefaultListener(listener, persistenceUnit);
        }
    }

    public void introspectDefaultListener(EntityListenerConfig listener, AmberPersistenceUnit persistenceUnit) throws ConfigException {
        String className = listener.getClassName();
        Class type = persistenceUnit.loadTempClass(className);
        if (type == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type for <entity-listener> in orm.xml", (Object)className));
        }
        ListenerType listenerType = persistenceUnit.addDefaultListener(type);
        this.introspectListener(type, listenerType);
    }

    public void introspectEntityListeners(Class type, EntityType entityType, AmberPersistenceUnit persistenceUnit) throws ConfigException {
        this.getInternalEntityListenersConfig(type, this._annotationCfg);
        EntityListeners entityListenersAnn = (EntityListeners)this._annotationCfg.getAnnotation();
        EntityListenersConfig entityListenersCfg = this._annotationCfg.getEntityListenersConfig();
        Object listeners = null;
        String entityTypeName = entityType.getBeanClass().getName();
        for (int i = 0; listeners != null && i < (listeners).length; ++i) {
            Class cl = null;
            if (listeners[i] instanceof Class) {
                cl = listeners[i];
            }
            if (persistenceUnit.getDefaultListener(cl.getName()) != null) continue;
            this.introspectEntityListener(cl, persistenceUnit, entityType, entityTypeName);
        }
    }

    public void introspectEntityListener(Class type, AmberPersistenceUnit persistenceUnit, EntityType sourceType, String sourceClassName) throws ConfigException {
        if (type == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type for @EntityListeners annotated at class '{1}'", (Object)type.getName(), (Object)sourceClassName));
        }
        Class parentClass = type.getSuperclass();
        if (parentClass == null) {
            return;
        }
        ListenerType listenerType = persistenceUnit.getEntityListener(type.getName());
        ListenerType newListenerType = persistenceUnit.addEntityListener(sourceClassName, type);
        if (listenerType == null) {
            listenerType = newListenerType;
            this.introspectListener(type, listenerType);
        }
        sourceType.addListener(listenerType);
    }

    public void introspectListener(Class type, ListenerType listenerType) throws ConfigException {
        listenerType.setInstanceClassName(listenerType.getName() + "__ResinExt");
        for (Method method : type.getDeclaredMethods()) {
            this.introspectCallbacks(listenerType, method);
        }
    }

    public void introspectCallbacks(Class type, EntityType entityType) throws ConfigException {
        this.getInternalExcludeDefaultListenersConfig(type, this._annotationCfg);
        if (!this._annotationCfg.isNull()) {
            entityType.setExcludeDefaultListeners(true);
        }
        this.getInternalExcludeSuperclassListenersConfig(type, this._annotationCfg);
        if (!this._annotationCfg.isNull()) {
            entityType.setExcludeSuperclassListeners(true);
        }
        for (Method method : type.getDeclaredMethods()) {
            this.introspectCallbacks(entityType, method);
        }
    }

    public void introspectCallbacks(AbstractEnhancedType type, Method method) throws ConfigException {
        Class<?>[] param = method.getParameterTypes();
        String methodName = method.getName();
        Class jClass = type.getBeanClass();
        boolean isListener = type instanceof ListenerType;
        int n = ListenerType.CALLBACK_CLASS.length;
        for (int i = 1; i < n; ++i) {
            this.getInternalCallbackConfig(i, jClass, method, methodName, this._annotationCfg);
            if (this._annotationCfg.isNull()) continue;
            this.validateCallback(ListenerType.CALLBACK_CLASS[i].getName(), method, isListener);
            type.addCallback(i, method);
        }
    }

    void introspectNamedQueries(Class type, String typeName) {
        this.getInternalNamedQueryConfig(type, this._annotationCfg);
        NamedQuery namedQueryAnn = (NamedQuery)this._annotationCfg.getAnnotation();
        NamedQueryConfig namedQueryConfig = this._annotationCfg.getNamedQueryConfig();
        NamedQueries namedQueriesAnn = type.getAnnotation(NamedQueries.class);
        if (namedQueryAnn == null && namedQueriesAnn == null) {
            return;
        }
        if (namedQueryAnn != null && namedQueriesAnn != null) {
            throw new ConfigException(L.l("{0} may not have both @NamedQuery and @NamedQueries", (Object)typeName));
        }
        NamedQuery[] namedQueryArray = namedQueriesAnn != null ? namedQueriesAnn.value() : new NamedQuery[]{namedQueryAnn};
        for (int i = 0; i < namedQueryArray.length; ++i) {
            namedQueryAnn = namedQueryArray[i];
            this._persistenceUnit.addNamedQuery(namedQueryAnn.name(), namedQueryAnn.query());
        }
    }

    void introspectNamedNativeQueries(Class type, String typeName) {
        this.getInternalNamedNativeQueryConfig(type, this._annotationCfg);
        NamedNativeQuery namedNativeQueryAnn = (NamedNativeQuery)this._annotationCfg.getAnnotation();
        NamedNativeQueryConfig namedNativeQueryConfig = this._annotationCfg.getNamedNativeQueryConfig();
        NamedNativeQueries namedNativeQueriesAnn = type.getAnnotation(NamedNativeQueries.class);
        if (namedNativeQueryAnn == null && namedNativeQueriesAnn == null) {
            return;
        }
        if (namedNativeQueryAnn != null && namedNativeQueriesAnn != null) {
            throw new ConfigException(L.l("{0} may not have both @NamedNativeQuery and @NamedNativeQueries", (Object)typeName));
        }
        NamedNativeQuery[] namedNativeQueryArray = namedNativeQueriesAnn != null ? namedNativeQueriesAnn.value() : new NamedNativeQuery[]{namedNativeQueryAnn};
        for (int i = 0; i < namedNativeQueryArray.length; ++i) {
            namedNativeQueryAnn = namedNativeQueryArray[i];
            NamedNativeQueryConfig nativeQueryConfig = new NamedNativeQueryConfig();
            nativeQueryConfig.setQuery(namedNativeQueryAnn.query());
            nativeQueryConfig.setResultClass(namedNativeQueryAnn.resultClass());
            nativeQueryConfig.setResultSetMapping(namedNativeQueryAnn.resultSetMapping());
            this._persistenceUnit.addNamedNativeQuery(namedNativeQueryAnn.name(), nativeQueryConfig);
        }
    }

    void introspectSqlResultSetMappings(Class type, EntityType entityType, String typeName) {
        this.getInternalSqlResultSetMappingConfig(type, this._annotationCfg);
        SqlResultSetMapping sqlResultSetMappingAnn = (SqlResultSetMapping)this._annotationCfg.getAnnotation();
        SqlResultSetMappingConfig sqlResultSetMappingConfig = this._annotationCfg.getSqlResultSetMappingConfig();
        SqlResultSetMappings sqlResultSetMappingsAnn = type.getAnnotation(SqlResultSetMappings.class);
        if (sqlResultSetMappingAnn == null && sqlResultSetMappingsAnn == null) {
            return;
        }
        if (sqlResultSetMappingAnn != null && sqlResultSetMappingsAnn != null) {
            throw new ConfigException(L.l("{0} may not have both @SqlResultSetMapping and @SqlResultSetMappings", (Object)typeName));
        }
        SqlResultSetMapping[] sqlResultSetMappingArray = sqlResultSetMappingsAnn != null ? sqlResultSetMappingsAnn.value() : new SqlResultSetMapping[]{sqlResultSetMappingAnn};
        if (sqlResultSetMappingConfig != null) {
            this._persistenceUnit.addSqlResultSetMapping(sqlResultSetMappingConfig.getName(), sqlResultSetMappingConfig);
            return;
        }
        for (int i = 0; i < sqlResultSetMappingArray.length; ++i) {
            sqlResultSetMappingAnn = sqlResultSetMappingArray[i];
            String name = sqlResultSetMappingAnn.name();
            EntityResult[] entities = sqlResultSetMappingAnn.entities();
            ColumnResult[] columns = sqlResultSetMappingAnn.columns();
            SqlResultSetMappingCompletion completion = new SqlResultSetMappingCompletion(entityType, name, entities, columns);
            this._depCompletions.add(completion);
        }
    }

    void addSqlResultSetMapping(String resultSetName, EntityResult[] entities, ColumnResult[] columns) throws ConfigException {
        int i;
        SqlResultSetMappingConfig sqlResultSetMapping = new SqlResultSetMappingConfig();
        for (i = 0; i < entities.length; ++i) {
            EntityResult entityResult = entities[i];
            String className = entityResult.entityClass().getName();
            EntityType resultType = this._persistenceUnit.getEntityType(className);
            if (resultType == null) {
                throw new ConfigException(L.l("entityClass '{0}' is not an @Entity bean for @SqlResultSetMapping '{1}'. The entityClass of an @EntityResult must be an @Entity bean.", (Object)className, (Object)resultSetName));
            }
            EntityResultConfig entityResultConfig = new EntityResultConfig();
            entityResultConfig.setEntityClass(className);
            FieldResult[] fields = entityResult.fields();
            for (int j = 0; j < fields.length; ++j) {
                FieldResult fieldResult = fields[j];
                String fieldName = fieldResult.name();
                AmberField field = resultType.getField(fieldName);
                if (field == null) {
                    throw new ConfigException(L.l("@FieldResult with field name '{0}' is not a field for @EntityResult bean '{1}' in @SqlResultSetMapping '{2}'", (Object)fieldName, (Object)className, (Object)resultSetName));
                }
                String columnName = fieldResult.column();
                if (columnName == null || columnName.length() == 0) {
                    throw new ConfigException(L.l("@FieldResult must have a column name defined and it must not be empty for '{0}' in @EntityResult '{1}' @SqlResultSetMapping '{2}'", (Object)fieldName, (Object)className, (Object)resultSetName));
                }
                FieldResultConfig fieldResultConfig = new FieldResultConfig();
                fieldResultConfig.setName(fieldName);
                fieldResultConfig.setColumn(columnName);
                entityResultConfig.addFieldResult(fieldResultConfig);
            }
            sqlResultSetMapping.addEntityResult(entityResultConfig);
        }
        for (i = 0; i < columns.length; ++i) {
            ColumnResult columnResult = columns[i];
            String columnName = columnResult.name();
            if (columnName == null || columnName.length() == 0) {
                throw new ConfigException(L.l("@ColumnResult must have a column name defined and it must not be empty in @SqlResultSetMapping '{0}'", (Object)resultSetName));
            }
            ColumnResultConfig columnResultConfig = new ColumnResultConfig();
            columnResultConfig.setName(columnName);
            sqlResultSetMapping.addColumnResult(columnResultConfig);
        }
        this._persistenceUnit.addSqlResultSetMapping(resultSetName, sqlResultSetMapping);
    }

    public void configureLinks() throws ConfigException {
        RuntimeException exn = null;
        while (this._linkCompletions.size() > 0) {
            Completion completion = this._linkCompletions.remove(0);
            try {
                completion.complete();
            }
            catch (Exception e) {
                if (e instanceof ConfigException) {
                    log.warning(e.getMessage());
                    log.log(Level.FINEST, e.toString(), e);
                } else {
                    log.log(Level.WARNING, e.toString(), e);
                }
                completion.getRelatedType().setConfigException(e);
                if (exn != null) continue;
                exn = ConfigException.create(e);
            }
        }
        if (exn != null) {
            throw exn;
        }
    }

    public void configureDependencies() throws ConfigException {
        RuntimeException exn = null;
        while (this._depCompletions.size() > 0) {
            Completion completion = this._depCompletions.remove(0);
            try {
                completion.complete();
            }
            catch (Exception e) {
                if (e instanceof ConfigException) {
                    log.warning(e.getMessage());
                    log.log(Level.FINEST, e.toString(), e);
                } else {
                    log.log(Level.WARNING, e.toString(), e);
                }
                completion.getRelatedType().setConfigException(e);
                if (exn != null) continue;
                exn = ConfigException.create(e);
            }
        }
        if (exn != null) {
            throw exn;
        }
    }

    void introspectIdMethod(AmberPersistenceUnit persistenceUnit, EntityType entityType, EntityType parentType, Class type, Class idClass, MappedSuperclassConfig config) throws ConfigException, SQLException {
        CompositeId id;
        ArrayList<IdField> keys = new ArrayList<IdField>();
        IdField idField = null;
        AttributesConfig attributesConfig = null;
        if (config != null) {
            attributesConfig = config.getAttributes();
        }
        for (Method method : type.getDeclaredMethods()) {
            String fieldName;
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (method.getDeclaringClass().equals(Object.class) || !methodName.startsWith("get") || paramTypes.length != 0 || BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName = BaseConfigIntrospector.toFieldName(methodName.substring(3)))) continue;
            this.getInternalIdConfig(type, method, fieldName, this._annotationCfg);
            Annotation id2 = this._annotationCfg.getAnnotation();
            IdConfig idConfig = this._annotationCfg.getIdConfig();
            if (!this._annotationCfg.isNull()) {
                idField = this.introspectId(persistenceUnit, entityType, method, fieldName, method.getReturnType(), idConfig);
                if (idField == null) continue;
                keys.add(idField);
                continue;
            }
            this.getInternalEmbeddedIdConfig(type, method, fieldName, this._annotationCfg);
            Annotation embeddedId = this._annotationCfg.getAnnotation();
            EmbeddedIdConfig embeddedIdConfig = this._annotationCfg.getEmbeddedIdConfig();
            if (this._annotationCfg.isNull()) continue;
            idField = this.introspectEmbeddedId(persistenceUnit, entityType, method, fieldName, method.getReturnType());
            break;
        }
        if (keys.size() == 0) {
            if (idField != null) {
                id = new com.caucho.amber.field.EmbeddedId(entityType, (EmbeddedIdField)idField);
                entityType.setId(id);
            }
        } else if (keys.size() == 1) {
            entityType.setId(new Id(entityType, keys));
        } else {
            if (idClass == null) {
                throw new ConfigException(L.l("{0} has multiple @Id methods, but no @IdClass.  Compound primary keys require either an @IdClass or exactly one @EmbeddedId field or property.", (Object)entityType.getName()));
            }
            id = new CompositeId(entityType, keys);
            id.setKeyClass(idClass);
            entityType.setId(id);
        }
    }

    void introspectIdField(AmberPersistenceUnit persistenceUnit, EntityType entityType, EntityType parentType, Class type, Class idClass, MappedSuperclassConfig config) throws ConfigException, SQLException {
        ArrayList<IdField> keys = new ArrayList<IdField>();
        AttributesConfig attributesConfig = null;
        if (config != null) {
            attributesConfig = config.getAttributes();
        }
        for (Field field : type.getDeclaredFields()) {
            IdField idField;
            String fieldName = field.getName();
            if (BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName)) continue;
            this.getInternalIdConfig(type, field, fieldName, this._annotationCfg);
            Annotation id = this._annotationCfg.getAnnotation();
            IdConfig idConfig = this._annotationCfg.getIdConfig();
            if (this._annotationCfg.isNull()) {
                this.getInternalEmbeddedIdConfig(type, field, fieldName, this._annotationCfg);
                Annotation embeddedId = this._annotationCfg.getAnnotation();
                EmbeddedIdConfig embeddedIdConfig = this._annotationCfg.getEmbeddedIdConfig();
                if (this._annotationCfg.isNull()) continue;
            }
            if ((idField = this.introspectId(persistenceUnit, entityType, field, fieldName, field.getType(), idConfig)) == null) continue;
            keys.add(idField);
        }
        if (keys.size() != 0) {
            if (keys.size() == 1) {
                entityType.setId(new Id(entityType, keys));
            } else {
                if (idClass == null) {
                    throw new ConfigException(L.l("{0} has multiple @Id fields, but no @IdClass.  Compound primary keys require an @IdClass.", (Object)entityType.getName()));
                }
                CompositeId id = new CompositeId(entityType, keys);
                id.setKeyClass(idClass);
                entityType.setId(id);
                this._configManager.introspect(idClass);
            }
        }
    }

    boolean isField(Class type, AbstractEnhancedConfig typeConfig, boolean isEmbeddable) throws ConfigException {
        if (type == null) {
            return false;
        }
        if (typeConfig != null) {
            String access = typeConfig.getAccess();
            if (access != null) {
                return access.equals("FIELD");
            }
            Class parentClass = type.getSuperclass();
            if (parentClass == null) {
                return false;
            }
            this.getInternalEntityConfig(parentClass, this._annotationCfg);
            EntityConfig superEntityConfig = this._annotationCfg.getEntityConfig();
            if (superEntityConfig == null) {
                return false;
            }
            return this.isField(parentClass, superEntityConfig, false);
        }
        for (Field field : type.getDeclaredFields()) {
            for (Class annType : _annTypes) {
                if (field.getAnnotation(annType) == null) continue;
                return true;
            }
        }
        return this.isField(type.getSuperclass(), null, false);
    }

    private IdField introspectId(AmberPersistenceUnit persistenceUnit, EntityType entityType, AccessibleObject field, String fieldName, Class fieldType, IdConfig idConfig) throws ConfigException, SQLException {
        javax.persistence.Id id = field.getAnnotation(javax.persistence.Id.class);
        Column column = field.getAnnotation(Column.class);
        ColumnConfig columnConfig = null;
        GeneratedValueConfig generatedValueConfig = null;
        if (idConfig != null) {
            columnConfig = idConfig.getColumn();
            generatedValueConfig = idConfig.getGeneratedValue();
        }
        GeneratedValue gen = field.getAnnotation(GeneratedValue.class);
        AmberType amberType = persistenceUnit.createType(fieldType);
        AmberColumn keyColumn = null;
        keyColumn = this.createColumn(entityType, field, fieldName, column, amberType, columnConfig);
        if (entityType.getTable() == null) {
            KeyPropertyField idField = new KeyPropertyField(entityType, fieldName, keyColumn);
            return idField;
        }
        KeyPropertyField idField = new KeyPropertyField(entityType, fieldName, keyColumn);
        if (gen != null) {
            Object metaData = null;
            if (GenerationType.IDENTITY.equals((Object)gen.strategy())) {
                keyColumn.setGeneratorType("identity");
                idField.setGenerator("identity");
            } else if (GenerationType.SEQUENCE.equals((Object)gen.strategy())) {
                this.addSequenceIdGenerator(persistenceUnit, idField, gen);
            } else if (GenerationType.TABLE.equals((Object)gen.strategy())) {
                this.addTableIdGenerator(persistenceUnit, idField, id);
            } else if (GenerationType.AUTO.equals((Object)gen.strategy())) {
                keyColumn.setGeneratorType("auto");
                idField.setGenerator("auto");
            }
        }
        return idField;
    }

    private IdField introspectEmbeddedId(AmberPersistenceUnit persistenceUnit, EntityType ownerType, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException, SQLException {
        EmbeddableType embeddableType = (EmbeddableType)this._configManager.introspect(fieldType);
        if (embeddableType == null) {
            throw new IllegalStateException("" + fieldType + " is an unsupported embeddable type");
        }
        EmbeddedIdField idField = new EmbeddedIdField(ownerType, embeddableType, fieldName);
        return idField;
    }

    void addSequenceIdGenerator(AmberPersistenceUnit persistenceUnit, KeyPropertyField idField, GeneratedValue genAnn) throws ConfigException {
        idField.setGenerator("sequence");
        idField.getColumn().setGeneratorType("sequence");
        String name = genAnn.generator();
        if (name == null || "".equals(name)) {
            name = idField.getEntitySourceType().getTable().getName() + "_cseq";
        }
        SequenceIdGenerator gen = persistenceUnit.createSequenceGenerator(name, 1);
        idField.getEntitySourceType().setGenerator(idField.getName(), gen);
    }

    void addTableIdGenerator(AmberPersistenceUnit persistenceUnit, KeyPropertyField idField, javax.persistence.Id idAnn) throws ConfigException {
        IdGenerator gen;
        idField.setGenerator("table");
        idField.getColumn().setGeneratorType("table");
        String name = null;
        if (name == null || "".equals(name)) {
            name = "caucho";
        }
        if ((gen = persistenceUnit.getTableGenerator(name)) == null) {
            String genName = "GEN_TABLE";
            GeneratorTableType genTable = persistenceUnit.createGeneratorTable(genName);
            gen = genTable.createGenerator(name);
            genTable.init();
            persistenceUnit.putTableGenerator(name, gen);
        }
        idField.getEntitySourceType().setGenerator(idField.getName(), gen);
    }

    void linkSecondaryTable(AmberTable primaryTable, AmberTable secondaryTable, PrimaryKeyJoinColumn[] joinColumnsAnn) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (AmberColumn column : primaryTable.getIdColumns()) {
            PrimaryKeyJoinColumn joinAnn = BaseConfigIntrospector.getJoinColumn(joinColumnsAnn, column.getName());
            String name = joinAnn == null ? column.getName() : joinAnn.name();
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    void linkInheritanceTable(AmberTable primaryTable, AmberTable secondaryTable, PrimaryKeyJoinColumn joinAnn, PrimaryKeyJoinColumnConfig pkJoinColumnCfg) throws ConfigException {
        PrimaryKeyJoinColumn[] joinAnns = null;
        if (joinAnn != null) {
            joinAnns = new PrimaryKeyJoinColumn[]{joinAnn};
        }
        this.linkInheritanceTable(primaryTable, secondaryTable, joinAnns, pkJoinColumnCfg);
    }

    void linkInheritanceTable(AmberTable primaryTable, AmberTable secondaryTable, PrimaryKeyJoinColumn[] joinColumnsAnn, PrimaryKeyJoinColumnConfig pkJoinColumnCfg) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (AmberColumn column : primaryTable.getIdColumns()) {
            PrimaryKeyJoinColumn join;
            String name = joinColumnsAnn == null ? (pkJoinColumnCfg == null ? column.getName() : pkJoinColumnCfg.getName()) : ((join = BaseConfigIntrospector.getJoinColumn(joinColumnsAnn, column.getName())) == null ? column.getName() : join.name());
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    void introspectMethods(AmberPersistenceUnit persistenceUnit, AmberBeanType entityType, AmberBeanType parentType, Class type, AbstractEnhancedConfig typeConfig) throws ConfigException {
        for (Method method : type.getDeclaredMethods()) {
            String propName;
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (method.getDeclaringClass().equals(Object.class)) continue;
            if (paramTypes.length != 0) {
                this.validateNonGetter(method);
                continue;
            }
            if (methodName.startsWith("get")) {
                propName = methodName.substring(3);
            } else if (methodName.startsWith("is") && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class))) {
                propName = methodName.substring(2);
            } else {
                this.validateNonGetter(method);
                continue;
            }
            this.getInternalVersionConfig(type, method, propName, this._annotationCfg);
            Annotation versionAnn = this._annotationCfg.getAnnotation();
            VersionConfig versionConfig = this._annotationCfg.getVersionConfig();
            if (!this._annotationCfg.isNull()) {
                this.validateNonGetter(method);
            } else {
                Method setter = null;
                try {
                    setter = this.getMethod(type, "set" + propName, new Class[]{method.getReturnType()});
                }
                catch (Exception e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
                if (Modifier.isPrivate(method.getModifiers()) || setter == null || Modifier.isPrivate(setter.getModifiers())) {
                    Annotation ann = this.isAnnotatedMethod(method);
                    if (ann == null) {
                        if (setter != null) {
                            ann = this.isAnnotatedMethod(setter);
                        }
                    } else if (ann instanceof Transient) continue;
                    if (ann == null) continue;
                    throw BaseConfigIntrospector.error(method, L.l("'{0}' is not a valid annotation for {1}.  Only public persistent property getters with matching setters may have property annotations.", (Object)ann.getClass(), (Object)BaseConfigIntrospector.getFullName(method)));
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    this.validateNonGetter(method);
                    continue;
                }
            }
            String fieldName = BaseConfigIntrospector.toFieldName(propName);
            if (BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName)) continue;
            Class<?> fieldType = method.getReturnType();
            this.introspectField(persistenceUnit, entityType, method, fieldName, fieldType, typeConfig);
        }
    }

    private Method getMethod(Class cl, String name, Class[] param) {
        if (cl == null) {
            return null;
        }
        block0: for (Method method : cl.getDeclaredMethods()) {
            Class<?>[] types;
            if (!method.getName().equals(name) || (types = method.getParameterTypes()).length != param.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (!param[i].equals(types[i])) continue block0;
            }
            return method;
        }
        return this.getMethod(cl.getSuperclass(), name, param);
    }

    void introspectFields(AmberPersistenceUnit persistenceUnit, AmberBeanType entityType, AmberBeanType parentType, Class type, AbstractEnhancedConfig typeConfig, boolean isEmbeddable) throws ConfigException {
        if (entityType.isEntity() && ((EntityType)entityType).getId() == null) {
            throw new ConfigException(L.l("{0} has no key", (Object)entityType));
        }
        for (Field field : type.getDeclaredFields()) {
            String fieldName = field.getName();
            if (BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            Class<?> fieldType = field.getType();
            this.introspectField(persistenceUnit, entityType, field, fieldName, fieldType, typeConfig);
        }
    }

    void introspectField(AmberPersistenceUnit persistenceUnit, AmberBeanType sourceType, AccessibleObject field, String fieldName, Class fieldType, AbstractEnhancedConfig typeConfig) throws ConfigException {
        EmbeddableConfig embeddableConfig = null;
        MappedSuperclassConfig mappedSuperOrEntityConfig = null;
        if (typeConfig instanceof EmbeddableConfig) {
            embeddableConfig = (EmbeddableConfig)typeConfig;
        } else if (typeConfig instanceof MappedSuperclassConfig) {
            mappedSuperOrEntityConfig = (MappedSuperclassConfig)typeConfig;
        }
        Class<?> jClass = field instanceof Field ? ((Field)field).getDeclaringClass() : ((Method)field).getDeclaringClass();
        if (jClass.isInterface()) {
            return;
        }
        AmberBeanType declaringType = this._persistenceUnit.getEntityType(jClass.getName());
        if (declaringType == null) {
            declaringType = this._persistenceUnit.getEmbeddable(jClass.getName());
        }
        if (declaringType == null) {
            declaringType = this._persistenceUnit.getMappedSuperclass(jClass.getName());
        }
        if (declaringType == null) {
            return;
        }
        AttributesConfig attributesConfig = null;
        IdConfig idConfig = null;
        BasicConfig basicConfig = null;
        OneToOneConfig oneToOneConfig = null;
        OneToManyConfig oneToManyConfig = null;
        ManyToOneConfig manyToOneConfig = null;
        ManyToManyConfig manyToManyConfig = null;
        VersionConfig versionConfig = null;
        Object elementCollectionConfig = null;
        if (mappedSuperOrEntityConfig != null && (attributesConfig = mappedSuperOrEntityConfig.getAttributes()) != null) {
            idConfig = attributesConfig.getId(fieldName);
            basicConfig = attributesConfig.getBasic(fieldName);
            oneToOneConfig = attributesConfig.getOneToOne(fieldName);
            oneToManyConfig = attributesConfig.getOneToMany(fieldName);
            elementCollectionConfig = null;
            manyToOneConfig = attributesConfig.getManyToOne(fieldName);
            manyToManyConfig = attributesConfig.getManyToMany(fieldName);
            versionConfig = attributesConfig.getVersion(fieldName);
        }
        if (idConfig != null || field.isAnnotationPresent(javax.persistence.Id.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@Id", _idAnnotations);
            if (!_idTypes.contains(fieldType.getName())) {
                throw BaseConfigIntrospector.error(field, L.l("{0} is an invalid @Id type for {1}.", (Object)fieldType.getName(), (Object)fieldName));
            }
        } else if (basicConfig != null || field.isAnnotationPresent(Basic.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@Basic", _basicAnnotations);
            BasicConfig basic = new BasicConfig(this, sourceType, field, fieldName, fieldType);
            basic.complete();
        } else if (versionConfig != null || field.isAnnotationPresent(Version.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@Version", _versionAnnotations);
            this.addVersion((EntityType)sourceType, field, fieldName, fieldType, versionConfig);
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@ManyToOne", _manyToOneAnnotations);
            ManyToOne ann = field.getAnnotation(ManyToOne.class);
            Class targetEntity = null;
            targetEntity = ann != null ? ann.targetEntity() : manyToOneConfig.getTargetEntity();
            if (targetEntity == null || targetEntity.getName().equals("void")) {
                targetEntity = fieldType;
            }
            this.getInternalEntityConfig(targetEntity, this._annotationCfg);
            Annotation targetEntityAnn = this._annotationCfg.getAnnotation();
            EntityConfig targetEntityConfig = this._annotationCfg.getEntityConfig();
            if (this._annotationCfg.isNull()) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal targetEntity for {1}.  @ManyToOne relations must target a valid @Entity.", (Object)targetEntity.getName(), (Object)fieldName));
            }
            if (!fieldType.isAssignableFrom(targetEntity)) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal targetEntity for {1}.  @ManyToOne targetEntity must be assignable to the field type '{2}'.", (Object)targetEntity.getName(), (Object)fieldName, (Object)fieldType.getName()));
            }
            EntityType entityType = (EntityType)sourceType;
            entityType.setHasDependent(true);
            this._linkCompletions.add(new ManyToOneConfig(this, entityType, field, fieldName, fieldType));
        } else if (oneToManyConfig != null || field.isAnnotationPresent(OneToMany.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@OneToMany", _oneToManyAnnotations);
            if (field.isAnnotationPresent(MapKey.class)) {
                if (!fieldType.getName().equals("java.util.Map")) {
                    throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal @OneToMany/@MapKey type for {1}. @MapKey must be a java.util.Map", (Object)fieldType.getName(), (Object)fieldName));
                }
            } else if (!_oneToManyTypes.contains(fieldType.getName())) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal @OneToMany type for {1}.  @OneToMany must be a java.util.Collection, java.util.List or java.util.Map", (Object)fieldType.getName(), (Object)fieldName));
            }
            EntityType entityType = (EntityType)sourceType;
            this._depCompletions.add(new OneToManyConfig(this, entityType, field, fieldName, fieldType));
        } else if (oneToOneConfig != null || field.isAnnotationPresent(OneToOne.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@OneToOne", _oneToOneAnnotations);
            EntityType entityType = (EntityType)sourceType;
            OneToOneConfig oneToOne = new OneToOneConfig(this, entityType, field, fieldName, fieldType);
            if (oneToOne.isOwningSide()) {
                this._linkCompletions.add(oneToOne);
            } else {
                this._depCompletions.add(0, oneToOne);
                entityType.setHasDependent(true);
            }
        } else if (manyToManyConfig != null || field.isAnnotationPresent(ManyToMany.class)) {
            if (field.isAnnotationPresent(MapKey.class) && !fieldType.getName().equals("java.util.Map")) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal @ManyToMany/@MapKey type for {1}. @MapKey must be a java.util.Map", (Object)fieldType.getName(), (Object)fieldName));
            }
            ManyToManyConfig manyToMany = new ManyToManyConfig(this, (EntityType)sourceType, field, fieldName, fieldType);
            if (manyToMany.isOwningSide()) {
                this._linkCompletions.add(manyToMany);
            } else {
                this._depCompletions.add(manyToMany);
            }
        } else if (elementCollectionConfig != null || field.isAnnotationPresent(ElementCollection.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@ElementCollection", _elementCollectionAnnotations);
            if (!_elementCollectionTypes.contains(fieldType.getName())) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal @ElementCollection type for {1}.  @ElementCollection must be a java.util.Collection, java.util.List or java.util.Map", (Object)fieldType.getName(), (Object)fieldName));
            }
            EntityType entityType = (EntityType)sourceType;
            ElementCollectionConfig comp = new ElementCollectionConfig(entityType, field, fieldName, fieldType);
            this._depCompletions.add(comp);
        } else if (field.isAnnotationPresent(Embedded.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@Embedded", _embeddedAnnotations);
            EntityType entityType = (EntityType)sourceType;
            entityType.setHasDependent(true);
            this._depCompletions.add(new EmbeddedCompletion(entityType, field, fieldName, fieldType, false));
        } else if (field.isAnnotationPresent(EmbeddedId.class)) {
            BaseConfigIntrospector.validateAnnotations(field, fieldName, "@EmbeddedId", _embeddedIdAnnotations);
            this._depCompletions.add(new EmbeddedCompletion((EntityType)sourceType, field, fieldName, fieldType, true));
        } else if (!field.isAnnotationPresent(Transient.class)) {
            BasicConfig basic = new BasicConfig(this, sourceType, field, fieldName, fieldType);
            basic.complete();
        }
    }

    void addVersion(EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType, VersionConfig versionConfig) throws ConfigException {
        AmberPersistenceUnit persistenceUnit = sourceType.getPersistenceUnit();
        Column columnAnn = field.getAnnotation(Column.class);
        ColumnConfig columnConfig = null;
        if (versionConfig != null) {
            columnConfig = versionConfig.getColumn();
        }
        if (!_versionTypes.contains(fieldType.getName())) {
            throw BaseConfigIntrospector.error(field, L.l("{0} is an invalid @Version type for {1}.", (Object)fieldType.getName(), (Object)fieldName));
        }
        AmberType amberType = persistenceUnit.createType(fieldType);
        AmberColumn fieldColumn = this.createColumn(sourceType, field, fieldName, columnAnn, amberType, columnConfig);
        VersionField version = new VersionField(sourceType, fieldName);
        version.setColumn(fieldColumn);
        sourceType.setVersionField(version);
    }

    private AmberColumn createColumn(AmberBeanType beanType, AccessibleObject field, String fieldName, Column columnAnn, AmberType amberType, ColumnConfig columnConfig) throws ConfigException {
        EntityType entityType = null;
        if (beanType instanceof EntityType) {
            entityType = (EntityType)beanType;
        }
        String name = columnAnn != null && !columnAnn.name().equals("") ? columnAnn.name() : (columnConfig != null && !columnConfig.getName().equals("") ? columnConfig.getName() : BaseConfigIntrospector.toSqlName(fieldName));
        AmberColumn column = null;
        if (entityType == null) {
            column = new AmberColumn(null, name, amberType);
        } else if (columnAnn != null && !columnAnn.table().equals("")) {
            String tableName = columnAnn.table();
            AmberTable table = entityType.getSecondaryTable(tableName);
            if (table == null) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column(table='{1}') is an unknown secondary table.", (Object)fieldName, (Object)tableName));
            }
            column = table.createColumn(name, amberType);
        } else {
            column = entityType.getTable() != null ? entityType.getTable().createColumn(name, amberType) : new AmberColumn(null, name, amberType);
        }
        if (column != null && columnAnn != null) {
            column.setUnique(columnAnn.unique());
            column.setNotNull(!columnAnn.nullable());
            if (!"".equals(columnAnn.columnDefinition())) {
                column.setSQLType(columnAnn.columnDefinition());
            }
            column.setLength(columnAnn.length());
            int precision = columnAnn.precision();
            if (precision < 0) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column precision cannot be less than 0.", (Object)fieldName));
            }
            int scale = columnAnn.scale();
            if (scale < 0) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column scale cannot be less than 0.", (Object)fieldName));
            }
            if (scale > precision) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column scale cannot be greater than precision. Must set precision to a non-zero value before setting scale.", (Object)fieldName));
            }
            if (precision > 0) {
                column.setPrecision(precision);
                column.setScale(scale);
            }
        }
        return column;
    }

    public static JoinColumn getJoinColumn(JoinColumns joinColumns, String keyName) {
        if (joinColumns == null) {
            return null;
        }
        return BaseConfigIntrospector.getJoinColumn(joinColumns.value(), keyName);
    }

    private AmberColumn findColumn(ArrayList<AmberColumn> columns, String ref) {
        if ((ref == null || ref.equals("")) && columns.size() == 1) {
            return columns.get(0);
        }
        for (AmberColumn column : columns) {
            if (!column.getName().equals(ref)) continue;
            return column;
        }
        return null;
    }

    public static JoinColumn getJoinColumn(JoinColumn[] columnsAnn, String keyName) {
        if (columnsAnn == null || columnsAnn.length == 0) {
            return null;
        }
        for (int i = 0; i < columnsAnn.length; ++i) {
            String ref = columnsAnn[i].referencedColumnName();
            if (!ref.equals("") && !ref.equals(keyName)) continue;
            return columnsAnn[i];
        }
        return null;
    }

    public static PrimaryKeyJoinColumn getJoinColumn(PrimaryKeyJoinColumn[] columnsAnn, String keyName) {
        if (columnsAnn == null || columnsAnn.length == 0) {
            return null;
        }
        for (int i = 0; i < columnsAnn.length; ++i) {
            String ref = columnsAnn[i].referencedColumnName();
            if (!ref.equals("") && !ref.equals(keyName)) continue;
            return columnsAnn[i];
        }
        return null;
    }

    void getInternalEmbeddableConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Embeddable.class);
        EmbeddableConfig embeddableConfig = null;
        if (this._embeddableConfigMap != null) {
            embeddableConfig = this._embeddableConfigMap.get(type.getName());
        }
        annotationCfg.setConfig(embeddableConfig);
    }

    void getInternalEntityConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Entity.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        annotationCfg.setConfig(entityConfig);
    }

    void getInternalMappedSuperclassConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, MappedSuperclass.class);
        MappedSuperclassConfig mappedSuperConfig = this.getMappedSuperclassConfig(type.getName());
        annotationCfg.setConfig(mappedSuperConfig);
    }

    void getInternalEntityListenersConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, EntityListeners.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        annotationCfg.setConfig(entityConfig.getEntityListeners());
    }

    void getInternalExcludeDefaultListenersConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, ExcludeDefaultListeners.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        if (entityConfig.getExcludeDefaultListeners()) {
            annotationCfg.setConfig(entityConfig.getExcludeDefaultListeners());
        }
    }

    void getInternalExcludeSuperclassListenersConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, ExcludeSuperclassListeners.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        if (entityConfig.getExcludeSuperclassListeners()) {
            annotationCfg.setConfig(entityConfig.getExcludeSuperclassListeners());
        }
    }

    void getInternalInheritanceConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Inheritance.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getInheritance());
        }
    }

    void getInternalNamedQueryConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, NamedQuery.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getNamedQuery());
        }
    }

    void getInternalNamedNativeQueryConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, NamedNativeQuery.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getNamedNativeQuery());
        }
    }

    void getInternalSqlResultSetMappingConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, SqlResultSetMapping.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getSqlResultSetMapping());
        }
    }

    void getInternalTableConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Table.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getTable());
        }
    }

    void getInternalSecondaryTableConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, SecondaryTable.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getSecondaryTable());
        }
    }

    void getInternalIdClassConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, IdClass.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        annotationCfg.setConfig(entityConfig.getIdClass());
    }

    void getInternalPrimaryKeyJoinColumnConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, PrimaryKeyJoinColumn.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getPrimaryKeyJoinColumn());
        }
    }

    void getInternalDiscriminatorColumnConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, DiscriminatorColumn.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getDiscriminatorColumn());
        }
    }

    void getInternalOneToOneConfig(Class type, AccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, OneToOne.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            OneToOneConfig oneToOne = attributes.getOneToOne(fieldName);
            annotationCfg.setConfig(oneToOne);
        }
    }

    void getInternalOneToManyConfig(Class type, AccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, OneToMany.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            OneToManyConfig oneToMany = attributes.getOneToMany(fieldName);
            annotationCfg.setConfig(oneToMany);
        }
    }

    void getInternalManyToOneConfig(Class type, AccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, ManyToOne.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            ManyToOneConfig manyToOne = attributes.getManyToOne(fieldName);
            annotationCfg.setConfig(manyToOne);
        }
    }

    void getInternalManyToManyConfig(Class type, AccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, ManyToMany.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            ManyToManyConfig manyToMany = attributes.getManyToMany(fieldName);
            annotationCfg.setConfig(manyToMany);
        }
    }

    void getInternalIdConfig(Class type, AccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(method, javax.persistence.Id.class);
        MappedSuperclassConfig mappedSuperclassOrEntityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (mappedSuperclassOrEntityConfig == null) {
            return;
        }
        AttributesConfig attributes = mappedSuperclassOrEntityConfig.getAttributes();
        if (attributes != null) {
            IdConfig id = attributes.getId(fieldName);
            annotationCfg.setConfig(id);
        }
    }

    void getInternalCallbackConfig(int callback, Class type, AccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        AbstractListenerConfig callbackConfig;
        annotationCfg.reset(method, ListenerType.CALLBACK_CLASS[callback]);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        switch (callback) {
            case 1: {
                callbackConfig = entityConfig.getPrePersist();
                break;
            }
            case 2: {
                callbackConfig = entityConfig.getPostPersist();
                break;
            }
            case 3: {
                callbackConfig = entityConfig.getPreRemove();
                break;
            }
            case 4: {
                callbackConfig = entityConfig.getPostRemove();
                break;
            }
            case 5: {
                callbackConfig = entityConfig.getPreUpdate();
                break;
            }
            case 6: {
                callbackConfig = entityConfig.getPostUpdate();
                break;
            }
            case 7: {
                callbackConfig = entityConfig.getPostLoad();
                break;
            }
            default: {
                return;
            }
        }
        if (callbackConfig == null) {
            return;
        }
        if (callbackConfig.getMethodName().equals(((Method)method).getName())) {
            annotationCfg.setConfig(callbackConfig);
        }
    }

    void getInternalEmbeddedIdConfig(Class type, AccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(method, EmbeddedId.class);
    }

    void getInternalVersionConfig(Class type, AccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(method, Version.class);
    }

    void getInternalJoinColumnConfig(Class type, AccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, JoinColumn.class);
    }

    void getInternalJoinTableConfig(Class type, AccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, JoinTable.class);
    }

    void getInternalMapKeyConfig(Class type, AccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, MapKey.class);
    }

    void getInternalAttributeOverrideConfig(Class type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, AttributeOverride.class);
    }

    private MappedSuperclassConfig getInternalMappedSuperclassOrEntityConfig(String name) {
        MappedSuperclassConfig mappedSuperclassConfig = null;
        mappedSuperclassConfig = this.getEntityConfig(name);
        if (mappedSuperclassConfig != null) {
            return mappedSuperclassConfig;
        }
        mappedSuperclassConfig = this.getMappedSuperclassConfig(name);
        return mappedSuperclassConfig;
    }

    static AttributeOverrideConfig convertAttributeOverrideAnnotationToConfig(Annotation attOverrideAnn) {
        throw new UnsupportedOperationException();
    }

    static AttributeOverrideConfig createAttributeOverrideConfig(String name, String columnName, boolean isNullable, boolean isUnique) {
        AttributeOverrideConfig attOverrideConfig = new AttributeOverrideConfig();
        attOverrideConfig.setName(name);
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(columnName);
        columnConfig.setNullable(isNullable);
        columnConfig.setUnique(isUnique);
        attOverrideConfig.setColumn(columnConfig);
        return attOverrideConfig;
    }

    class SqlResultSetMappingCompletion
    extends CompletionImpl {
        private String _name;
        private EntityResult[] _entities;
        private ColumnResult[] _columns;

        SqlResultSetMappingCompletion(EntityType type, String name, EntityResult[] entities, ColumnResult[] columns) {
            super(BaseConfigIntrospector.this, type);
            this._name = name;
            this._entities = entities;
            this._columns = columns;
        }

        public void complete() throws ConfigException {
            BaseConfigIntrospector.this.addSqlResultSetMapping(this._name, this._entities, this._columns);
        }
    }

    class EmbeddedCompletion
    extends CompletionImpl {
        private AccessibleObject _field;
        private String _fieldName;
        private Class _fieldType;
        private boolean _embeddedId;

        EmbeddedCompletion(EntityType type, AccessibleObject field, String fieldName, Class fieldType, boolean embeddedId) {
            super(BaseConfigIntrospector.this, type, fieldName);
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
            this._embeddedId = embeddedId;
        }

        public void complete() throws ConfigException {
            boolean hasAttributeOverrides;
            BaseConfigIntrospector.this.getInternalAttributeOverrideConfig(this._entityType.getBeanClass(), BaseConfigIntrospector.this._annotationCfg);
            AttributeOverride attributeOverrideAnn = (AttributeOverride)BaseConfigIntrospector.this._annotationCfg.getAnnotation();
            AttributeOverrideConfig attributeOverrideConfig = BaseConfigIntrospector.this._annotationCfg.getAttributeOverrideConfig();
            boolean hasAttributeOverride = !BaseConfigIntrospector.this._annotationCfg.isNull();
            AttributeOverrides attributeOverridesAnn = this._field.getAnnotation(AttributeOverrides.class);
            boolean bl = hasAttributeOverrides = attributeOverridesAnn != null;
            if (hasAttributeOverride && hasAttributeOverrides) {
                throw AbstractConfigIntrospector.error(this._field, L.l("{0} may not have both @AttributeOverride and @AttributeOverrides", (Object)this._fieldName));
            }
            AttributeOverride[] attOverridesAnn = null;
            if (attributeOverrideAnn != null) {
                attOverridesAnn = new AttributeOverride[]{attributeOverrideAnn};
            } else if (attributeOverridesAnn != null) {
                attOverridesAnn = attributeOverridesAnn.value();
            }
            AmberPersistenceUnit persistenceUnit = this._entityType.getPersistenceUnit();
            EmbeddableType type = persistenceUnit.createEmbeddable(this._fieldType);
            EntityEmbeddedField embeddedField = this._embeddedId ? this._entityType.getId().getEmbeddedIdField() : new EntityEmbeddedField(this._entityType, type, this._fieldName);
            embeddedField.setLazy(false);
            this._entityType.addField(embeddedField);
            AmberTable sourceTable = this._entityType.getTable();
            HashMap embeddedColumns = new HashMap();
            HashMap fieldNameByColumn = new HashMap();
            for (EmbeddedSubField subField : embeddedField.getSubFields()) {
                String embeddedFieldName = subField.getName();
                String columnName = AbstractConfigIntrospector.toSqlName(embeddedFieldName);
                boolean notNull = false;
                boolean unique = false;
                if (attOverridesAnn == null) continue;
                for (int j = 0; j < attOverridesAnn.length; ++j) {
                    Column columnAnn;
                    if (!embeddedFieldName.equals(attOverridesAnn[j].name()) || (columnAnn = attOverridesAnn[j].column()) == null) continue;
                    columnName = columnAnn.name();
                    notNull = !columnAnn.nullable();
                    unique = columnAnn.unique();
                    subField.getColumn().setName(columnName);
                    subField.getColumn().setNotNull(notNull);
                    subField.getColumn().setUnique(unique);
                }
            }
            embeddedField.init();
        }
    }
}

