/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.entity;

import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.CacheConnection;
import com.caucho.util.CurrentTime;
import java.sql.SQLException;

public class CacheableEntityItem
extends EntityItem {
    private AmberEntityHome _home;
    private Entity _cacheEntity;
    private long _expireTime;

    public CacheableEntityItem(AmberEntityHome home, Entity cacheEntity) {
        this._home = home;
        this._cacheEntity = cacheEntity;
        cacheEntity.__caucho_setConnection(null);
        if (cacheEntity.__caucho_isLoaded()) {
            this._expireTime = CurrentTime.getCurrentTime() + this._home.getCacheTimeout();
        }
    }

    public AmberEntityHome getEntityHome() {
        return this._home;
    }

    public Entity getEntity() {
        long now = CurrentTime.getCurrentTime();
        if (this._expireTime < now) {
            long timeout = this._home.getCacheTimeout();
            boolean isExpired = this._expireTime > 0L && timeout > 0L;
            this._expireTime = now + timeout;
            if (isExpired) {
                this._cacheEntity.__caucho_expire();
            }
        }
        return this._cacheEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity loadEntity(int loadGroup) {
        long now = CurrentTime.getCurrentTime();
        if (this._expireTime < now) {
            this._expireTime = now + this._home.getCacheTimeout();
            this._cacheEntity.__caucho_expire();
        }
        CacheConnection aConn = this._home.getManager().getCacheConnection();
        try {
            this._cacheEntity.__caucho_retrieve_self(aConn);
        }
        finally {
            aConn.freeConnection();
        }
        return this._cacheEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity loadEntity(AmberConnection aConn, int loadGroup) {
        long now = CurrentTime.getCurrentTime();
        if (this._expireTime < now) {
            this._expireTime = now + this._home.getCacheTimeout();
            this._cacheEntity.__caucho_expire();
        }
        try {
            this._cacheEntity.__caucho_retrieve_self(aConn);
        }
        finally {
            this._cacheEntity.__caucho_setConnection(null);
        }
        return this._cacheEntity;
    }

    public Entity createEntity(AmberConnection aConn, Object key) throws SQLException {
        Entity cacheEntity = this.getEntity();
        AmberEntityHome home = this.getEntityHome();
        return cacheEntity.__caucho_home_new(home, key, aConn, this);
    }

    public void save(Entity item) {
    }

    public void savePart(Entity item) {
    }

    public void expire() {
        this._cacheEntity.__caucho_expire();
    }

    Class getInstanceClass() {
        return this._cacheEntity.getClass();
    }

    public String toString() {
        return "CacheableEntityItem[" + this._cacheEntity + "]";
    }
}

