/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractPathExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ElementCollectionIdExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.OneToManyJoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.ElementCollectionField;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.ElementType;
import com.caucho.util.CharBuffer;

public class ElementCollectionExpr
extends AbstractPathExpr {
    private PathExpr _parent;
    private LinkColumns _linkColumns;
    private ElementType _targetType;
    private FromItem _fromItem;
    private FromItem _childFromItem;

    public ElementCollectionExpr(QueryParser parser, PathExpr parent, LinkColumns linkColumns, ElementType targetType) {
        this._parent = parent;
        this._targetType = targetType;
        this._linkColumns = linkColumns;
    }

    public LinkColumns getLinkColumns() {
        return this._linkColumns;
    }

    public AmberType getType() {
        return this._linkColumns.getSourceTable().getType();
    }

    public IdExpr createId(FromItem fromItem) {
        return new ElementCollectionIdExpr(fromItem, this);
    }

    public AmberBeanType getTargetType() {
        return this._targetType;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return from == this._childFromItem || type == 1 && this._parent.usesFrom(from, type);
    }

    public PathExpr getParent() {
        return this._parent;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        return this.bindSelect(parser, null);
    }

    public PathExpr bindSelect(QueryParser parser, String id) {
        if (this._fromItem != null) {
            return this;
        }
        this._fromItem = this._parent.bindSubPath(parser);
        AmberTable sourceTable = this._linkColumns.getSourceTable();
        this._childFromItem = parser.addFromItem(sourceTable, id);
        OneToManyJoinExpr joinExpr = new OneToManyJoinExpr(this._linkColumns, this._childFromItem, this._fromItem);
        this._childFromItem.setJoinExpr(joinExpr);
        this._childFromItem.setCollectionExpr(this);
        return this;
    }

    public FromItem getChildFromItem() {
        return this._childFromItem;
    }

    public FromItem bindSubPath(QueryParser parser) {
        if (this._childFromItem == null) {
            this.bindSelect(parser, null);
        }
        return this._childFromItem;
    }

    public AmberTable getTable() {
        return this._fromItem.getTable();
    }

    public void generateWhere(CharBuffer cb) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public void generateSelect(CharBuffer cb) {
        String id = this._childFromItem.getName();
        ElementCollectionField field = (ElementCollectionField)this._targetType.getField();
        cb.append(field.generateLoadSelect(id));
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ElementCollectionExpr eltCollection = (ElementCollectionExpr)o;
        return this._parent.equals(eltCollection._parent) && this._linkColumns.equals(eltCollection._linkColumns);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._parent + "," + this._linkColumns + "]";
    }
}

