/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr.fun;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.fun.FunExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatFunExpr
extends FunExpr {
    private static final L10N L = new L10N(ConcatFunExpr.class);

    protected ConcatFunExpr(QueryParser parser, ArrayList<AmberExpr> args) {
        super(parser, "concat", args, false);
    }

    public static FunExpr create(QueryParser parser, ArrayList<AmberExpr> args) {
        return new ConcatFunExpr(parser, args);
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    void generateInternalWhere(CharBuffer cb, boolean select) {
        ArrayList<AmberExpr> args = this.getArgs();
        int n = args.size();
        if (this._parser.isDerbyDBMS()) {
            cb.append("VARCHAR(CAST(");
            if (select) {
                args.get(0).generateWhere(cb);
            } else {
                args.get(0).generateUpdateWhere(cb);
            }
            cb.append("AS VARCHAR(2000)) || CAST(");
            if (select) {
                args.get(1).generateWhere(cb);
            } else {
                args.get(1).generateUpdateWhere(cb);
            }
            cb.append(" AS VARCHAR(2000)))");
            return;
        }
        if (this._parser.isPostgresDBMS()) {
            this.generateInternalConcat(cb, true, true, null, select);
            return;
        }
        cb.append("concat");
        this.generateInternalConcat(cb, true, true, null, select);
    }

    private void generateInternalConcat(CharBuffer cb, boolean arg0, boolean arg1, String str, boolean select) {
        ArrayList<AmberExpr> args = this.getArgs();
        boolean usesConcatOperator = this._parser.isDerbyDBMS() || this._parser.isPostgresDBMS();
        cb.append('(');
        if (arg0) {
            if (select) {
                args.get(0).generateWhere(cb);
            } else {
                args.get(0).generateUpdateWhere(cb);
            }
            if (usesConcatOperator) {
                cb.append(" || ");
            } else {
                cb.append(',');
            }
        }
        if (arg1) {
            if (select) {
                args.get(1).generateWhere(cb);
            } else {
                args.get(1).generateUpdateWhere(cb);
            }
            if (arg0) {
                cb.append(')');
                return;
            }
            if (usesConcatOperator) {
                cb.append(" || ");
            } else {
                cb.append(',');
            }
        }
        cb.append('\'');
        cb.append(str);
        cb.append('\'');
        cb.append(')');
    }
}

