/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ManyToOneExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CascadableField;
import com.caucho.amber.field.DependentEntityOneToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.persistence.CascadeType;
import javax.persistence.JoinColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToOneField
extends CascadableField {
    private static final L10N L = new L10N(ManyToOneField.class);
    private static final Logger log = Logger.getLogger(ManyToOneField.class.getName());
    private LinkColumns _linkColumns;
    private EntityType _targetType;
    private int _targetLoadIndex;
    private DependentEntityOneToOneField _targetField;
    private AmberField _aliasField;
    private boolean _isInsert = true;
    private boolean _isUpdate = true;
    private boolean _isSourceCascadeDelete;
    private boolean _isTargetCascadeDelete;
    private boolean _isManyToOne;
    private JoinColumn[] _joinColumnsAnn;
    private HashMap<String, JoinColumnConfig> _joinColumnMap = null;

    public ManyToOneField(EntityType relatedType, String name, CascadeType[] cascadeType, boolean isManyToOne) throws ConfigException {
        super(relatedType, name, cascadeType);
        this._isManyToOne = isManyToOne;
    }

    public ManyToOneField(EntityType relatedType, String name, CascadeType[] cascadeType) throws ConfigException {
        super(relatedType, name, cascadeType);
    }

    public ManyToOneField(EntityType relatedType, String name) throws ConfigException {
        this(relatedType, name, null);
    }

    public ManyToOneField(EntityType relatedType) {
        super(relatedType);
    }

    public void setType(AmberType targetType) {
        if (!(targetType instanceof EntityType)) {
            throw new AmberRuntimeException(L.l("many-to-one requires an entity target at '{0}'", (Object)targetType));
        }
        this._targetType = (EntityType)targetType;
    }

    public EntityType getRelatedType() {
        return (EntityType)this.getSourceType();
    }

    public EntityType getEntityTargetType() {
        return this._targetType;
    }

    public String getForeignTypeName() {
        return this.getEntityTargetType().getForeignTypeName();
    }

    public boolean isAnnotatedManyToOne() {
        return this._isManyToOne;
    }

    public void setTargetCascadeDelete(boolean isCascadeDelete) {
        this._isTargetCascadeDelete = isCascadeDelete;
    }

    public void setSourceCascadeDelete(boolean isCascadeDelete) {
        this._isSourceCascadeDelete = isCascadeDelete;
    }

    public boolean isTargetCascadeDelete() {
        return this._isTargetCascadeDelete;
    }

    public boolean isSourceCascadeDelete() {
        return this._isSourceCascadeDelete;
    }

    public void setJoinColumns(JoinColumn[] joinColumnsAnn) {
        this._joinColumnsAnn = joinColumnsAnn;
    }

    public Object[] getJoinColumns() {
        return this._joinColumnsAnn;
    }

    public void setJoinColumnMap(HashMap<String, JoinColumnConfig> joinColumnMap) {
        this._joinColumnMap = joinColumnMap;
    }

    public HashMap<String, JoinColumnConfig> getJoinColumnMap() {
        return this._joinColumnMap;
    }

    public void setLinkColumns(LinkColumns linkColumns) {
        this._linkColumns = linkColumns;
    }

    public LinkColumns getLinkColumns() {
        return this._linkColumns;
    }

    public void setTargetField(DependentEntityOneToOneField field) {
        this._targetField = field;
    }

    public void setAliasField(AmberField alias) {
        this._aliasField = alias;
    }

    @Override
    public AmberField override(AmberBeanType type) {
        ManyToOneField field = new ManyToOneField((EntityType)this.getSourceType(), this.getName(), this.getCascadeType(), this._isManyToOne);
        field.setOverride(true);
        field.setLazy(this.isLazy());
        return field;
    }

    @Override
    public void init() throws ConfigException {
        this.init(this.getRelatedType());
    }

    public void init(EntityType relatedType) throws ConfigException {
        boolean isJPA = relatedType.getPersistenceUnit().isJPA();
        int loadGroupIndex = this.getEntitySourceType().getDefaultLoadGroupIndex();
        super.setLoadGroupIndex(loadGroupIndex);
        this._targetLoadIndex = isJPA ? loadGroupIndex : relatedType.nextLoadGroupIndex();
        AmberTable sourceTable = relatedType.getTable();
        if (sourceTable == null || !isJPA) {
            super.init();
            return;
        }
        this.setSourceCascadeDelete(this.isCascade(CascadeType.REMOVE));
        int n = 0;
        if (this._joinColumnMap != null) {
            n = this._joinColumnMap.size();
        }
        ArrayList<ForeignColumn> foreignColumns = new ArrayList<ForeignColumn>();
        EntityType parentType = this._targetType;
        ArrayList<AmberColumn> targetIdColumns = this._targetType.getId().getColumns();
        while (targetIdColumns.size() == 0 && (parentType = parentType.getParentType()) != null) {
            targetIdColumns = parentType.getId().getColumns();
        }
        for (AmberColumn keyColumn : targetIdColumns) {
            String columnName = this.getName() + '_' + keyColumn.getName();
            boolean nullable = true;
            boolean unique = false;
            if (n > 0) {
                JoinColumnConfig joinColumn = n == 1 ? (JoinColumnConfig)this._joinColumnMap.values().toArray()[0] : this._joinColumnMap.get(keyColumn.getName());
                if (joinColumn != null) {
                    if (!"".equals(joinColumn.getName())) {
                        columnName = joinColumn.getName();
                    }
                    nullable = joinColumn.isNullable();
                    unique = joinColumn.isUnique();
                }
            } else {
                JoinColumn joinAnn = BaseConfigIntrospector.getJoinColumn(this._joinColumnsAnn, keyColumn.getName());
                if (joinAnn != null) {
                    columnName = joinAnn.name();
                    nullable = joinAnn.nullable();
                    unique = joinAnn.unique();
                }
            }
            ForeignColumn foreignColumn = sourceTable.createForeignColumn(columnName, keyColumn);
            foreignColumn.setNotNull(!nullable);
            foreignColumn.setUnique(unique);
            foreignColumns.add(foreignColumn);
        }
        LinkColumns linkColumns = new LinkColumns(sourceTable, this._targetType.getTable(), foreignColumns);
        this.setLinkColumns(linkColumns);
        super.init();
        Id id = this.getEntityTargetType().getId();
        ArrayList<AmberColumn> keys = id.getColumns();
        if (this._linkColumns == null) {
            ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
            for (int i = 0; i < keys.size(); ++i) {
                AmberColumn key = keys.get(i);
                String name = keys.size() == 1 ? this.getName() : this.getName() + "_" + key.getName();
                columns.add(sourceTable.createForeignColumn(name, key));
            }
            this._linkColumns = new LinkColumns(relatedType.getTable(), this._targetType.getTable(), columns);
        }
        if (relatedType.getId() != null) {
            for (IdField field : relatedType.getId().getKeys()) {
                for (ForeignColumn column : this._linkColumns.getColumns()) {
                    if (field.getColumn() == null || !field.getColumn().getName().equals(column.getName())) continue;
                    this._aliasField = field;
                }
            }
        }
        this._targetLoadIndex = relatedType.getLoadGroupIndex();
        this._linkColumns.setTargetCascadeDelete(this.isTargetCascadeDelete());
        this._linkColumns.setSourceCascadeDelete(this.isSourceCascadeDelete());
    }

    @Override
    public void generatePostConstructor(JavaWriter out) throws IOException {
        if (this._aliasField == null) {
            out.println(this.getSetterName() + "(" + this.generateSuperGetter("this") + ");");
        }
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new ManyToOneExpr(parent, this._linkColumns);
    }

    public ForeignColumn getColumn(AmberColumn targetColumn) {
        return this._linkColumns.getSourceColumn(targetColumn);
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
        if (this._isInsert && this._aliasField == null) {
            this._linkColumns.generateInsert(columns);
        }
    }

    @Override
    public String generateLoadSelect(AmberTable table, String id) {
        if (this._aliasField != null) {
            return null;
        }
        if (this._linkColumns == null) {
            return null;
        }
        if (this._linkColumns.getSourceTable() != table) {
            return null;
        }
        return this._linkColumns.generateSelectSQL(id);
    }

    @Override
    public String generateSelect(String id) {
        if (this._aliasField != null) {
            return null;
        }
        return this._linkColumns.generateSelectSQL(id);
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        if (this._aliasField != null) {
            return;
        }
        if (this._isUpdate) {
            sql.append(this._linkColumns.generateUpdateSQL());
        }
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        out.println();
        Id id = this.getEntityTargetType().getId();
        out.println("protected transient " + id.getForeignTypeName() + " __caucho_field_" + this.getName() + ";");
        if (this._aliasField == null) {
            id.generatePrologue(out, completedSet, this.getName());
        }
    }

    public void generateJoin(CharBuffer cb, String sourceTable, String targetTable) {
        cb.append(this._linkColumns.generateJoin(sourceTable, targetTable));
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this._aliasField != null) {
            return index;
        }
        out.print("__caucho_field_" + this.getName() + " = ");
        index = this.getEntityTargetType().getId().generateLoadForeign(out, rs, indexVar, index, this.getName());
        out.println(";");
        int group = this._targetLoadIndex / 64;
        long mask = 1L << this._targetLoadIndex % 64;
        return index;
    }

    @Override
    public int generatePostLoadSelect(JavaWriter out, int index) throws IOException {
        if (!this.isLazy()) {
            out.println(this.getGetterName() + "();");
        }
        return ++index;
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        String javaType = this.getJavaTypeName();
        out.println();
        out.println("public " + javaType + " " + this.getGetterName() + "()");
        out.println("{");
        out.pushDepth();
        int keyLoadIndex = this.getLoadGroupIndex();
        int entityLoadIndex = this._targetLoadIndex;
        int group = entityLoadIndex / 64;
        long mask = 1L << entityLoadIndex % 64;
        String loadVar = "__caucho_loadMask_" + group;
        out.println("if (__caucho_session == null || __caucho_state.isDeleting()) {");
        out.println("  return " + this.generateSuperGetter("this") + ";");
        out.println("}");
        out.println();
        String index = "_" + group;
        index = index + "_" + mask;
        if (this._aliasField == null) {
            out.println("if ((" + loadVar + " & " + mask + "L) == 0)");
            out.println("  __caucho_load_select_" + this.getLoadGroupIndex() + "(__caucho_session);");
        }
        out.println(loadVar + " |= " + mask + "L;");
        String varName = this.generateLoadProperty(out, index, "__caucho_session");
        out.println("return " + varName + ";");
        out.popDepth();
        out.println("}");
    }

    public String generateLoadProperty(JavaWriter out, String index, String session) throws IOException {
        boolean isJPA = this.getRelatedType().getPersistenceUnit().isJPA();
        String targetTypeExt = this._targetType.getInstanceClassName();
        String otherKey = this._aliasField == null ? "__caucho_field_" + this.getName() : this._aliasField.generateGet("super");
        String proxyType = this.getEntityTargetType().getProxyClass().getName();
        boolean isProxy = !isJPA;
        String varName = "v" + index;
        String proxyVarName = isProxy ? "p" + index : varName;
        if (isProxy) {
            out.println(proxyType + " " + proxyVarName + " = null;");
        }
        out.println(targetTypeExt + " " + varName + " = null;");
        out.println();
        Id id = this.getEntityTargetType().getId();
        String nullTest = otherKey + " != null";
        out.println("if (" + nullTest + ") {");
        out.pushDepth();
        long targetGroup = 0L;
        long targetMask = 0L;
        if (this._targetField != null) {
            long targetLoadIndex = this._targetField.getTargetLoadIndex();
            targetGroup = targetLoadIndex / 64L;
            targetMask = 1L << (int)(targetLoadIndex % 64L);
        }
        out.println(varName + " = (" + targetTypeExt + ") " + session + ".loadEntity(" + targetTypeExt + ".class, " + otherKey + ", " + !this.isLazy() + ");");
        if (this.isAbstract() && (this.isLazy() || !isJPA)) {
            String proxy = session + ".loadProxy(\"" + this.getEntityTargetType().getName() + "\", __caucho_field_" + this.getName() + ")";
            if (isJPA) {
                proxyType = targetTypeExt;
            }
            proxy = proxyVarName + " = (" + proxyType + ") " + proxy + ";";
            out.println(proxy);
        }
        out.popDepth();
        out.println("}");
        out.println(this.generateSuperSetter("this", proxyVarName) + ";");
        return proxyVarName;
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
        out.println();
        out.println("public void " + this.getSetterName() + "(" + this.getJavaTypeName() + " v)");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session == null) {");
        out.println("  " + this.generateSuperSetter("this", "v") + ";");
        out.println("  return;");
        out.println("}");
        String targetClassName = this.getEntityTargetType().getInstanceClassName();
        Id id = this.getEntityTargetType().getId();
        String var = "__caucho_field_" + this.getName();
        String keyType = this.getEntityTargetType().getId().getForeignTypeName();
        int group = this.getLoadGroupIndex() / 64;
        long loadMask = 1L << this.getLoadGroupIndex() % 64;
        String loadVar = "__caucho_loadMask_" + group;
        if (this._aliasField == null) {
            out.println();
            out.println("if ((" + loadVar + " & " + loadMask + "L) == 0) {");
            out.println("  __caucho_load_select_" + group + "(__caucho_session);");
            out.println("}");
            out.println();
            out.println(this.generateSuperSetter("this", "v") + ";");
            out.println();
            out.println("if (v == null) {");
            out.println("  if (" + var + " == null)");
            out.println("    return;");
            out.println();
            out.println("  " + var + " = null;");
            out.println("} else {");
            out.pushDepth();
            out.println(targetClassName + " newV = (" + targetClassName + ") v;");
            out.print(keyType + " key = ");
            EntityType targetType = this.getEntityTargetType();
            if (targetType.isEJBProxy(this.getJavaTypeName())) {
                out.print(id.generateGetProxyKey("v"));
            } else {
                out.print(id.toObject(id.generateGet("newV")));
            }
            out.println(";");
            out.println();
            out.println("if (key.equals(" + var + "))");
            out.println("  return;");
            out.println();
            out.println(var + " = key;");
            out.popDepth();
            out.println("}");
            out.println();
            int entityGroup = this._targetLoadIndex / 64;
            long entityLoadMask = 1L << this._targetLoadIndex % 64;
            String entityLoadVar = "__caucho_loadMask_" + group;
            out.println(entityLoadVar + " |= " + entityLoadMask + "L;");
            String dirtyVar = "__caucho_dirtyMask_" + this.getIndex() / 64;
            long dirtyMask = 1L << this.getIndex() % 64;
            out.println(dirtyVar + " |= " + dirtyMask + "L;");
            out.println("__caucho_session.update((com.caucho.amber.entity.Entity) this);");
            out.println("__caucho_session.addCompletion(__caucho_home.createManyToOneCompletion(\"" + this.getName() + "\", (com.caucho.amber.entity.Entity) this, v));");
            out.println();
        } else {
            out.println("throw new IllegalStateException(\"aliased field cannot be set\");");
        }
        out.popDepth();
        out.println("}");
    }

    void generateSetTargetLoadMask(JavaWriter out, String varName) throws IOException {
        boolean isJPA = this.getRelatedType().getPersistenceUnit().isJPA();
        if (this._targetField != null && isJPA) {
            long targetLoadIndex = this._targetField.getTargetLoadIndex();
            long targetGroup = targetLoadIndex / 64L;
            long targetMask = 1L << (int)(targetLoadIndex % 64L);
            varName = "((" + this._targetType.getInstanceClassName() + ") " + varName + ")";
            String thisContextEntity = "(" + this._targetField.getJavaTypeName() + ") contextEntity";
            out.println(this._targetField.generateSuperSetter(varName, thisContextEntity) + ";");
        }
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getIndex() != updateIndex) {
            return;
        }
        String var = "__caucho_field_" + this.getName();
        out.println(this.generateAccessor(dst, var) + " = " + this.generateAccessor(src, var) + ";");
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        String targetTypeExt;
        if (this.getLoadGroupIndex() != updateIndex) {
            return;
        }
        String var = "__caucho_field_" + this.getName();
        boolean isJPA = this.getEntitySourceType().getPersistenceUnit().isJPA();
        if (isJPA && !dst.equals("cacheEntity") && !dst.equals("super") && !dst.equals("item")) {
            String value = this.generateGet(src);
            out.println("// " + dst);
            if (this._targetType instanceof EntityType) {
                targetTypeExt = this.getEntityTargetType().getInstanceClassName();
                out.println("if (isFullMerge)");
                out.println("  child = " + value + ";");
                out.println("else {");
                out.pushDepth();
                out.println("child = aConn.getCacheEntity(" + targetTypeExt + ".class, " + var + ");");
                out.println();
                out.println("if (child == null && " + value + " != null)");
                out.println("  child = ((com.caucho.amber.entity.Entity) " + value + ").__caucho_getCacheEntity();");
                out.popDepth();
                out.println("}");
            } else {
                out.println("child = null;");
            }
            out.println("if (child != null) {");
            out.pushDepth();
            targetTypeExt = this.getEntityTargetType().getInstanceClassName();
            out.println("if (isFullMerge) {");
            out.pushDepth();
            out.println("child = aConn.load(child.getClass(), ((com.caucho.amber.entity.Entity) child).__caucho_getPrimaryKey(), true);");
            out.popDepth();
            out.println("} else {");
            out.pushDepth();
            out.println("com.caucho.amber.entity.Entity newChild = aConn.addNewEntity(child.getClass(), ((com.caucho.amber.entity.Entity) child).__caucho_getPrimaryKey());");
            out.println("if (newChild == null) {");
            out.pushDepth();
            value = "aConn.getEntity((com.caucho.amber.entity.Entity) child)";
            out.println("newChild = " + value + ";");
            out.popDepth();
            out.println("} else {");
            out.pushDepth();
            out.println("((com.caucho.amber.entity.Entity) child).__caucho_copyTo(newChild, aConn, (com.caucho.amber.entity.EntityItem) null);");
            out.popDepth();
            out.println("}");
            out.println("child = newChild;");
            out.popDepth();
            out.println("}");
            out.popDepth();
            out.println("}");
            value = "(" + targetTypeExt + ") child";
            out.println("if (isFullMerge)");
            out.println("  " + this.generateSet(dst, value) + ";");
        }
        out.println(this.generateAccessor(dst, var) + " = " + this.generateAccessor(src, var) + ";");
        if (!(dst.equals("cacheEntity") || dst.equals("super") || dst.equals("item"))) {
            String targetObject;
            if (isJPA) {
                targetTypeExt = this.getEntityTargetType().getInstanceClassName();
                targetObject = "(" + targetTypeExt + ") child";
            } else {
                targetObject = this.generateSuperGetter("this");
            }
            String objThis = "((" + this.getRelatedType().getInstanceClassName() + ") " + dst + ")";
            out.println(this.generateSuperSetter(objThis, targetObject) + ";");
        }
    }

    @Override
    public void generateMergeFrom(JavaWriter out, String dst, String src) throws IOException {
        if (!(this.getEntityTargetType() instanceof EntityType)) {
            return;
        }
        String value = this.generateGet(src);
        out.println("if (" + value + " != null) {");
        out.pushDepth();
        value = this.isCascade(CascadeType.MERGE) ? "(" + this.getJavaTypeName() + ") aConn.recursiveMerge(" + value + ")" : "(" + this.getJavaTypeName() + ") aConn.mergeDetachedEntity((com.caucho.amber.entity.Entity) " + value + ")";
        out.println(this.generateSet(dst, value) + ";");
        out.popDepth();
        out.println("}");
    }

    private String generateAccessor(String src, String var) {
        if (src.equals("super")) {
            return var;
        }
        return "((" + this.getRelatedType().getInstanceClassName() + ") " + src + ")." + var;
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index, String source) throws IOException {
        IdField key;
        if (this._aliasField != null) {
            return;
        }
        if (source == null) {
            throw new NullPointerException();
        }
        String var = "__caucho_field_" + this.getName();
        if (!source.equals("this") && !source.equals("super")) {
            var = source + "." + var;
        }
        if (!this.isAbstract() || !this.getRelatedType().getPersistenceUnit().isJPA()) {
            out.println("if (" + var + " != null) {");
        } else if (this.isCascade(CascadeType.PERSIST)) {
            out.println("if (" + var + " != null) {");
        } else {
            String amberVar = this.getFieldName();
            out.println("com.caucho.amber.entity.EntityState " + amberVar + "_state = (" + var + " == null) ? ");
            out.println("com.caucho.amber.entity.EntityState.TRANSIENT : ");
            out.println("((com.caucho.amber.entity.Entity) " + amberVar + ").");
            out.println("__caucho_getEntityState();");
            out.println("if (" + amberVar + "_state.isTransactional()) {");
        }
        out.pushDepth();
        Id id = this.getEntityTargetType().getId();
        ArrayList<IdField> keys = id.getKeys();
        if (keys.size() == 1) {
            IdField key2 = keys.get(0);
            key2.getType().generateSet(out, pstmt, index, key2.getType().generateCastFromObject(var));
        } else {
            for (int i = 0; i < keys.size(); ++i) {
                key = keys.get(i);
                key.getType().generateSet(out, pstmt, index, key.generateGetKeyProperty(var));
            }
        }
        out.popDepth();
        out.println("} else {");
        out.pushDepth();
        for (int i = 0; i < keys.size(); ++i) {
            key = keys.get(i);
            key.getType().generateSetNull(out, pstmt, index);
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        String var = "__caucho_field_" + this.getName();
        out.println(var + " = " + obj + "." + var + ";");
    }

    @Override
    public void generatePrePersist(JavaWriter out) throws IOException {
        EntityType targetType = this.getEntityTargetType();
        if (!(targetType instanceof EntityType)) {
            return;
        }
        String fieldVar = "__caucho_field_" + this.getName();
        String className = targetType.getInstanceClassName();
        String var = "v_" + out.generateId();
        out.println();
        out.println(className + " " + var + " = (" + className + ") " + this.generateSuperGetter("this") + ";");
        Id id = targetType.getId();
        out.println("if (" + var + " != null) {");
        out.pushDepth();
        if (this.isCascade(CascadeType.PERSIST)) {
            out.println(var + " = (" + className + ") aConn.persistFromCascade(" + var + ");");
            out.println(var + ".__caucho_flush();");
        }
        out.print(fieldVar + " = ");
        out.print(id.toObject(id.generateGet(var)));
        out.println(";");
        String loadVar = "__caucho_loadMask_" + this._targetLoadIndex / 64;
        long loadMask = (long)this._targetLoadIndex % 64L;
        out.println(loadVar + " |= " + loadMask + "L;");
        out.println(this.generateSuperSetter("this", var) + ";");
        out.popDepth();
        out.println("} else {");
        out.println("  " + fieldVar + " = null;");
        out.println("}");
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        out.println("if (\"" + this._targetType.getTable().getName() + "\".equals(table)) {");
        out.pushDepth();
        String loadVar = "__caucho_loadMask_" + this._targetLoadIndex / 64;
        out.println(loadVar + " = 0L;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generatePreDelete(JavaWriter out) throws IOException {
        if (!this.isTargetCascadeDelete()) {
            return;
        }
        String var = "caucho_field_" + this.getName();
        out.println(this.getJavaTypeName() + " " + var + " = " + this.getGetterName() + "();");
    }

    @Override
    public void generatePostDelete(JavaWriter out) throws IOException {
        if (!this.isTargetCascadeDelete()) {
            return;
        }
        String var = "caucho_field_" + this.getName();
        out.println("if (" + var + " != null) {");
        out.println("  try {");
        out.println("    " + var + ".remove();");
        out.println("  } catch (Exception e) {");
        out.println("    throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("  }");
        out.println("}");
    }
}

