/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.entity.TableInvalidateCompletion;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.UserQuery;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;

public class AmberDeleteQuery
extends AbstractQuery {
    private String _sql;

    AmberDeleteQuery(String query, JdbcMetaData metaData) {
        super(query, metaData);
    }

    void setWhere(AmberExpr expr) {
        this._where = expr;
    }

    public String getSQL() {
        return this._sql;
    }

    void init() throws QueryParseException {
        super.init();
        CharBuffer cb = CharBuffer.allocate();
        cb.append("DELETE FROM ");
        FromItem item = (FromItem)this._fromList.get(0);
        cb.append(item.getTable().getName());
        if (this.getMetaData().supportsUpdateTableAlias() && this._fromList.size() > 1 || this.hasSubQuery()) {
            cb.append(" ");
            cb.append(item.getName());
        }
        if (this._where != null) {
            cb.append(" WHERE ");
            this._where.generateUpdateWhere(cb);
        }
        this._sql = cb.close();
    }

    public void prepare(UserQuery userQuery, AmberConnection aConn) throws SQLException {
        aConn.flushNoChecks();
    }

    public void complete(UserQuery userQuery, AmberConnection aConn) throws SQLException {
        aConn.expire();
        FromItem item = (FromItem)this._fromList.get(0);
        aConn.addCompletion(new TableInvalidateCompletion(item.getEntityType().getTable().getName()));
    }

    public String toString() {
        return "DeleteQuery[" + this.getQueryString() + "]";
    }
}

