/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.table;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.AmberType;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmberColumn {
    private static final L10N L = new L10N(AmberColumn.class);
    private AmberTable _table;
    private String _name;
    private String _configLocation;
    private AmberType _type;
    private boolean _isPrimaryKey;
    private String _sqlType;
    private boolean _isNotNull;
    private boolean _isUnique;
    private int _length;
    private int _precision;
    private int _scale;
    private String _generatorType;
    private String _generator;
    private String _fieldName;

    AmberColumn(AmberTable table, String name) {
        this._table = table;
        this._name = name;
    }

    public AmberColumn(AmberTable table, String name, AmberType type) {
        this._table = table;
        this._name = name;
        this._type = type;
    }

    public AmberTable getTable() {
        return this._table;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setConfigLocation(String location) {
        this._configLocation = location;
    }

    public AmberType getType() {
        return this._type;
    }

    public void setPrimaryKey(boolean isPrimaryKey) {
        this._isPrimaryKey = isPrimaryKey;
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    public void setGeneratorType(String type) {
        this._generatorType = type;
    }

    public String generateInsertName() {
        return this._name;
    }

    public void setSQLType(String sqlType) {
        this._sqlType = sqlType;
    }

    public String getSQLType() {
        return this._sqlType;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getLength() {
        return this._length;
    }

    public void setNotNull(boolean isNotNull) {
        this._isNotNull = isNotNull;
    }

    public boolean isNotNull() {
        return this._isNotNull;
    }

    public void setPrecision(int precision) {
        this._precision = precision;
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setScale(int scale) {
        this._scale = scale;
    }

    public int getScale() {
        return this._scale;
    }

    public void setUnique(boolean isUnique) {
        this._isUnique = isUnique;
    }

    public boolean isUnique() {
        return this._isUnique;
    }

    String generateCreateTableSQL(AmberPersistenceUnit manager) {
        CharBuffer cb = new CharBuffer();
        cb.append(this._name + " ");
        String sqlType = this._sqlType;
        sqlType = this._sqlType != null ? this._sqlType : this._type.generateCreateColumnSQL(manager, this._length, this._precision, this._scale);
        String generatorType = this._generatorType;
        if ("auto".equals(this._generatorType) && manager.getMetaData().supportsIdentity()) {
            generatorType = "identity";
        }
        if ("identity".equals(generatorType)) {
            cb.append(manager.getMetaData().createIdentitySQL(sqlType));
        } else {
            cb.append(sqlType);
        }
        if (this.isPrimaryKey()) {
            cb.append(" primary key");
        } else if (!"identity".equals(generatorType)) {
            if (this.isNotNull()) {
                cb.append(" not null");
            }
            if (this.isUnique()) {
                cb.append(" unique");
            }
        }
        return cb.toString();
    }

    void validateDatabase(AmberPersistenceUnit amberPersistenceUnit) throws ConfigException {
        try {
            DataSource ds = amberPersistenceUnit.getDataSource();
            Connection conn = ds.getConnection();
            try {
                Statement stmt = conn.createStatement();
                String sql = "select " + this.getName() + " from " + this._table.getName() + " where 1=0";
                try {
                    ResultSet rs = stmt.executeQuery(sql);
                    rs.close();
                    return;
                }
                catch (SQLException e) {
                    throw this.error(L.l("'{0}' is not a valid database column in table '{1}'.  Either the table needs to be created or the create-database-tables attribute must be set.\n\n  {2}\n\n{3}", (Object)this.getName(), (Object)this.getTable().getName(), (Object)sql, (Object)e.toString()), e);
                }
            }
            finally {
                conn.close();
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public String generateSelect(String id) {
        if (id != null) {
            return id + "." + this._name;
        }
        return this._name;
    }

    public String generateMatchArgWhere(String id) {
        if (id != null) {
            return id + "." + this._name + "=?";
        }
        return this._name + "=?";
    }

    public String generateUpdateSet() {
        return this._name + "=?";
    }

    public String generateUpdateSetNull() {
        return this._name + "=null";
    }

    public void generatePrologue(JavaWriter out) throws IOException {
    }

    public String getFieldName() {
        return "__amber_" + this.getName();
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (value != null) {
            this._type.generateSet(out, pstmt, index, value);
        } else {
            this._type.generateSetNull(out, pstmt, index);
        }
    }

    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        this._type.generateSetVersion(out, pstmt, index, value);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this._type.generateLoad(out, rs, indexVar, index);
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        return this._type.generateLoadNative(out, index);
    }

    public void generateNativeColumnNames(ArrayList<String> names) {
        names.add(this._name);
    }

    public Object toObjectKey(long value) {
        return this.getType().toObject(value);
    }

    protected ConfigException error(String msg, Throwable e) {
        if (this._configLocation != null) {
            return new LineConfigException(this._configLocation + msg, e);
        }
        if (this._table.getLocation() != null) {
            return new LineConfigException(this._table.getLocation() + msg, e);
        }
        return new ConfigException(msg, e);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

