/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.actor;

import com.caucho.amp.AmpQueryCallback;
import com.caucho.amp.actor.ActorRefImpl;
import com.caucho.amp.actor.AmpActor;
import com.caucho.amp.actor.AmpActorContext;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.actor.AmpMethodRef;
import com.caucho.amp.mailbox.AmpMailbox;
import com.caucho.amp.mailbox.AmpMailboxFactory;
import com.caucho.amp.stream.AmpEncoder;
import com.caucho.amp.stream.AmpError;
import com.caucho.amp.stream.AmpStream;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.ExpandableArray;
import com.caucho.util.WeakAlarm;

public final class ActorContextImpl
extends AmpActorContext
implements AmpActor,
AlarmListener {
    private final String _address;
    private final AmpActor _actor;
    private final AmpMailbox _mailbox;
    private final AmpActorRef _from;
    private long _timeout = 900000L;
    private long _qId;
    private final ExpandableArray<QueryItem> _queryMap = new ExpandableArray<QueryItem>(QueryItem.class);
    private Alarm _alarm = new WeakAlarm(this);

    public ActorContextImpl(String address, AmpActor actorStream, AmpMailboxFactory mailboxFactory) {
        this._address = address;
        this._actor = actorStream;
        this._mailbox = mailboxFactory.createMailbox(this);
        this._from = new ActorRefImpl(address, this._mailbox, this);
        this._qId = CurrentTime.getCurrentTime() << 16;
    }

    public String getAddress() {
        return this._address;
    }

    public AmpMailbox getMailbox() {
        return this._mailbox;
    }

    public AmpActorRef getActorRef() {
        return this._from;
    }

    public AmpStream getStream() {
        return this;
    }

    public AmpMethodRef getMethod(String methodName, AmpEncoder encoder) {
        return this._actor.getMethod(methodName, encoder);
    }

    public long getQueryTimeout() {
        return this._timeout;
    }

    public void setQueryTimeout(long timeout) {
        this._timeout = timeout;
    }

    public final void send(AmpActorRef to, AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        this._actor.send(to, from, encoder, methodName, args);
    }

    public void error(AmpActorRef to, AmpActorRef from, AmpEncoder encoder, AmpError error) {
        this._actor.error(to, from, encoder, error);
    }

    public void query(long id, AmpActorRef to, AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        this._actor.query(id, to, from, encoder, methodName, args);
    }

    public void queryResult(long id, AmpActorRef to, AmpActorRef from, AmpEncoder encoder, Object result) {
        QueryItem queryItem = this.extractQuery(id);
        if (queryItem != null) {
            queryItem.onQueryResult(to, from, encoder, result);
        } else {
            this._actor.queryResult(id, to, from, encoder, result);
        }
    }

    public void queryError(long id, AmpActorRef to, AmpActorRef from, AmpEncoder encoder, AmpError error) {
        QueryItem queryItem = this.extractQuery(id);
        if (queryItem != null) {
            queryItem.onQueryError(to, from, error);
        } else {
            this._actor.queryError(id, to, from, encoder, error);
        }
    }

    public void query(AmpMethodRef methodRef, Object[] args, AmpQueryCallback cb, long timeout) {
        long id = this.addQueryCallback(cb, timeout);
        methodRef.query(id, this._from, args);
    }

    long addQueryCallback(AmpQueryCallback callback, long timeout) {
        long id = this._qId++;
        QueryItem item = new QueryItem(id, callback, timeout);
        this._queryMap.add(item);
        Alarm alarm = this._alarm;
        long expireTime = timeout + CurrentTime.getCurrentTime();
        if (!(alarm == null || alarm.isQueued() && expireTime >= alarm.getWakeTime())) {
            alarm.queueAt(expireTime);
        }
        return id;
    }

    private QueryItem extractQuery(long id) {
        QueryItem[] queries = this._queryMap.getArray();
        int size = this._queryMap.getSize();
        for (int i = 0; i < size; ++i) {
            QueryItem query = queries[i];
            if (query.getId() != id) continue;
            this._queryMap.remove(i);
            return query;
        }
        return null;
    }

    public void close() {
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }

    public void handleAlarm(Alarm alarm) {
    }

    static final class QueryItem {
        private final long _id;
        private final AmpQueryCallback _callback;
        private final long _expires;

        QueryItem(long id, AmpQueryCallback callback, long expires) {
            this._id = id;
            this._callback = callback;
            this._expires = expires;
        }

        final long getId() {
            return this._id;
        }

        final long getExpires() {
            return this._expires;
        }

        void onQueryResult(AmpActorRef to, AmpActorRef from, AmpEncoder encoder, Object value) {
            this._callback.onQueryResult(to, from, value);
        }

        void onQueryError(AmpActorRef to, AmpActorRef from, AmpError error) {
            this._callback.onQueryError(to, from, error);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._id + "," + this._callback + "]";
        }
    }
}

