/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.actor;

import com.caucho.amp.AmpQueryCallback;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.stream.AmpError;
import com.caucho.bam.TimeoutException;
import com.caucho.util.CurrentTime;
import java.util.concurrent.locks.LockSupport;

public final class AmpQueryFuture
implements AmpQueryCallback {
    private final long _timeout;
    private volatile Object _result;
    private volatile AmpError _error;
    private volatile ResultState _resultState = ResultState.UNSET;
    private volatile Thread _thread;

    public AmpQueryFuture(long timeout) {
        this._timeout = timeout;
    }

    public final Object getResult() {
        return this._result;
    }

    public final AmpError getError() {
        return this._error;
    }

    public final Object get() throws TimeoutException {
        ResultState resultState = this._resultState;
        switch (resultState) {
            case RESULT: {
                return this._result;
            }
            case ERROR: {
                throw new RuntimeException(String.valueOf(this.getError()));
            }
            case UNSET: {
                resultState = this.waitFor(this._timeout);
                switch (resultState) {
                    case UNSET: {
                        throw new TimeoutException(this + " query timeout");
                    }
                    case ERROR: {
                        throw new RuntimeException(String.valueOf(this.getError()));
                    }
                    case RESULT: {
                        return this._result;
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    private ResultState waitFor(long timeout) {
        this._thread = Thread.currentThread();
        long now = CurrentTime.getCurrentTimeActual();
        long expires = now + timeout;
        while (this._resultState == ResultState.UNSET && CurrentTime.getCurrentTimeActual() < expires) {
            try {
                Thread.interrupted();
                LockSupport.parkUntil(expires);
            }
            catch (Exception e) {}
        }
        this._thread = null;
        return this._resultState;
    }

    public void onQueryResult(AmpActorRef to, AmpActorRef from, Object result) {
        this._result = result;
        this._resultState = ResultState.RESULT;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public void onQueryError(AmpActorRef to, AmpActorRef from, AmpError error) {
        this._error = error;
        this._resultState = ResultState.ERROR;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._result + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResultState {
        UNSET,
        RESULT,
        ERROR;

    }
}

