/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.impl;

import com.caucho.amp.AmpManager;
import com.caucho.amp.AmpManagerBuilder;
import com.caucho.amp.actor.AbstractAmpActor;
import com.caucho.amp.actor.ActorContextImpl;
import com.caucho.amp.actor.AmpActor;
import com.caucho.amp.actor.AmpActorContext;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.actor.AmpProxyActor;
import com.caucho.amp.broker.AmpBroker;
import com.caucho.amp.broker.AmpBrokerFactory;
import com.caucho.amp.mailbox.AmpMailbox;
import com.caucho.amp.mailbox.AmpMailboxBuilder;
import com.caucho.amp.mailbox.AmpMailboxBuilderFactory;
import com.caucho.amp.mailbox.AmpMailboxFactory;
import com.caucho.amp.skeleton.AmpReflectionSkeletonFactory;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmpManagerImpl
implements AmpManager {
    private final AtomicLong _clientId = new AtomicLong();
    private final AmpBroker _broker;
    private final AmpMailboxBuilderFactory _mailboxBuilderFactory;
    private final AmpMailboxBuilder _mailboxFactory;
    private final AmpActorContext _systemContext;

    public AmpManagerImpl(AmpManagerBuilder builder) {
        AmpBrokerFactory brokerFactory = builder.getBrokerFactory();
        AmpBroker broker = brokerFactory.createBroker();
        if (broker == null) {
            throw new NullPointerException();
        }
        this._broker = broker;
        AmpMailboxBuilderFactory mailboxBuilderFactory = builder.getMailboxBuilderFactory();
        if (mailboxBuilderFactory == null) {
            throw new NullPointerException();
        }
        this._mailboxBuilderFactory = mailboxBuilderFactory;
        this._mailboxFactory = this._mailboxBuilderFactory.createMailboxBuilder();
        AbstractAmpActor nullStream = new AbstractAmpActor();
        this._systemContext = new ActorContextImpl("system", nullStream, this._mailboxFactory);
    }

    @Override
    public AmpBroker getBroker() {
        return this._broker;
    }

    @Override
    public AmpActorContext getSystemContext() {
        return this._systemContext;
    }

    @Override
    public <T> T createActorProxy(String to, Class<T> api) {
        String from = "urn:amp:client:/" + api.getSimpleName() + "/" + this._clientId.incrementAndGet();
        return this.createClient(api, to, from);
    }

    @Override
    public <T> T createActorProxy(AmpActorRef to, Class<T> api) {
        AmpReflectionSkeletonFactory factory = new AmpReflectionSkeletonFactory();
        return factory.createStub(api, to, this._systemContext);
    }

    public <T> T createClient(Class<T> api, String to, String from) {
        AmpReflectionSkeletonFactory factory = new AmpReflectionSkeletonFactory();
        AmpProxyActor proxyActor = new AmpProxyActor(from, this._mailboxFactory);
        AmpMailbox mailbox = proxyActor.getActorContext().getMailbox();
        AmpActorRef toRef = this.getBroker().getActorRef(to);
        this.getBroker().addMailbox(from, mailbox);
        return factory.createStub(api, toRef, this._systemContext);
    }

    @Override
    public AmpActorRef addActor(String address, AmpActor actor) {
        AmpActorContext actorContext = this.createActorContext(address, actor);
        return this.getBroker().addMailbox(address, actorContext.getMailbox());
    }

    @Override
    public AmpActorRef addActor(String address, Object bean) {
        AmpReflectionSkeletonFactory factory = new AmpReflectionSkeletonFactory();
        AmpActor actor = factory.createSkeleton(bean, address, this.getBroker());
        return this.addActor(address, actor);
    }

    protected AmpActorContext createActorContext(String address, AmpActor actor) {
        return new ActorContextImpl(address, actor, this.getMailboxFactory());
    }

    protected AmpMailboxFactory getMailboxFactory() {
        return this._mailboxFactory;
    }
}

