/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.router;

import com.caucho.amp.AmpManager;
import com.caucho.amp.AmpQueryCallback;
import com.caucho.amp.actor.AbstractActorRef;
import com.caucho.amp.actor.AmpActorContext;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.actor.AmpMethodRef;
import com.caucho.amp.stream.AmpEncoder;
import com.caucho.amp.stream.AmpError;
import com.caucho.amp.stream.NullEncoder;

public class FirstActorRouter
extends AbstractActorRef {
    private final AmpActorContext _systemContext;
    private final AmpActorRef[] _actors;

    public FirstActorRouter(AmpManager manager, AmpActorRef ... actors) {
        this._systemContext = manager.getSystemContext();
        this._actors = actors;
    }

    public String getAddress() {
        return this._actors[0].getAddress();
    }

    public AmpMethodRef getMethod(String methodName, AmpEncoder encoder) {
        AmpMethodRef[] methods = new AmpMethodRef[this._actors.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = this._actors[i].getMethod(methodName, encoder);
        }
        return new FirstMethodRef(this._systemContext, methods);
    }

    static class FirstMethodCallback
    implements AmpQueryCallback {
        private final AmpActorContext _systemContext;
        private final long _id;
        private final AmpActorRef _from;
        private final AmpMethodRef[] _methods;
        private final Object[] _args;
        private int _index;

        FirstMethodCallback(AmpActorContext systemContext, long id, AmpActorRef from, AmpMethodRef[] methods, Object[] args) {
            this._systemContext = systemContext;
            this._id = id;
            this._from = from;
            this._methods = methods;
            this._args = args;
        }

        void start() {
            if (!this.nextQuery()) {
                this._from.queryError(this._id, this._from, NullEncoder.ENCODER, new AmpError());
            }
        }

        public void onQueryResult(AmpActorRef to, AmpActorRef from, Object result) {
            this._from.reply(this._id, from, NullEncoder.ENCODER, result);
        }

        public void onQueryError(AmpActorRef to, AmpActorRef from, AmpError error) {
            if (!this.nextQuery()) {
                this._from.queryError(this._id, from, NullEncoder.ENCODER, error);
            }
        }

        private boolean nextQuery() {
            if (this._index < this._methods.length) {
                int index = this._index;
                this._index = index + 1;
                AmpActorContext cxt = AmpActorContext.getCurrent(this._systemContext);
                cxt.query(this._methods[index], this._args, this, 5000L);
                return true;
            }
            return false;
        }
    }

    static class FirstMethodRef
    implements AmpMethodRef {
        private final AmpActorContext _systemContext;
        private final AmpMethodRef[] _methods;

        FirstMethodRef(AmpActorContext systemContext, AmpMethodRef[] methods) {
            this._systemContext = systemContext;
            this._methods = methods;
        }

        public void send(AmpActorRef from, Object ... args) {
            int i = 0;
            if (i < this._methods.length) {
                this._methods[i].send(from, args);
                return;
            }
        }

        public void query(long id, AmpActorRef from, Object ... args) {
            new FirstMethodCallback(this._systemContext, id, from, this._methods, args).start();
        }
    }
}

