/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.skeleton;

import com.caucho.amp.actor.AbstractAmpActor;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.actor.AmpMethodRef;
import com.caucho.amp.stream.AmpEncoder;
import com.caucho.amp.stream.AmpError;
import com.caucho.amp.stream.NullEncoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class AmpReflectionSkeleton
extends AbstractAmpActor {
    private static final Logger log = Logger.getLogger(AmpReflectionSkeleton.class.getName());
    private HashMap<String, Method> _methodMap = new HashMap();
    private final String _address;
    private final Object _bean;

    AmpReflectionSkeleton(String address, Object bean) {
        this._address = address;
        this._bean = bean;
        for (Method method : bean.getClass().getDeclaredMethods()) {
            this._methodMap.put(method.getName(), method);
        }
    }

    public AmpMethodRef getMethod(String methodName, AmpEncoder encoder) {
        Method method = this._methodMap.get(methodName);
        if (method == null) {
            throw new NullPointerException(methodName);
        }
        AmpActorRef to = null;
        return new SkeletonMethodRef(to, this._bean, method);
    }

    public void send(AmpActorRef to, AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        try {
            this.invokeMethod(encoder, methodName, args);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            from.error(from, NullEncoder.ENCODER, new AmpError());
        }
    }

    public void query(long id, AmpActorRef to, AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        try {
            Object result = this.invokeMethod(encoder, methodName, args);
            from.reply(id, to, NullEncoder.ENCODER, result);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            from.queryError(id, to, NullEncoder.ENCODER, new AmpError());
        }
    }

    private Object invokeMethod(AmpEncoder encoder, String methodName, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this._methodMap.get(methodName);
        if (method == null) {
            throw new IllegalStateException("unknown method: " + methodName);
        }
        return method.invoke(this._bean, args);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._address + "," + this._bean + "]";
    }

    static class SkeletonMethodRef
    implements AmpMethodRef {
        private final AmpActorRef _to;
        private final Object _bean;
        private final Method _method;

        SkeletonMethodRef(AmpActorRef to, Object bean, Method method) {
            this._to = to;
            this._bean = bean;
            this._method = method;
        }

        public void send(AmpActorRef from, Object ... args) {
            try {
                this._method.invoke(this._bean, args);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
                from.error(null, NullEncoder.ENCODER, new AmpError());
            }
        }

        public void query(long id, AmpActorRef from, Object ... args) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this._bean + " " + this._method.getName() + " call " + id + " from " + from);
                }
                Object result = this._method.invoke(this._bean, args);
                from.reply(id, this._to, NullEncoder.ENCODER, result);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
                from.queryError(id, this._to, NullEncoder.ENCODER, new AmpError());
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._method.getName() + ",to=" + this._to + "]";
        }
    }
}

