/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.common;

import com.caucho.amqp.common.AmqpConnectionHandler;
import com.caucho.amqp.common.AmqpLink;
import com.caucho.amqp.common.AmqpReceiverLink;
import com.caucho.amqp.common.AmqpSenderLink;
import com.caucho.amqp.common.TransferSettleManager;
import com.caucho.amqp.io.AmqpError;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.DeliveryAccepted;
import com.caucho.amqp.io.DeliveryModified;
import com.caucho.amqp.io.DeliveryRejected;
import com.caucho.amqp.io.DeliveryReleased;
import com.caucho.amqp.io.DeliveryState;
import com.caucho.amqp.io.FrameFlow;
import com.caucho.amqp.io.FrameTransfer;
import com.caucho.message.DistributionMode;
import com.caucho.message.SettleMode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmqpSession {
    private static final Logger log = Logger.getLogger(AmqpSession.class.getName());
    private AmqpConnectionHandler _conn;
    private ArrayList<AmqpLink> _incomingLinks = new ArrayList();
    private ArrayList<AmqpLink> _outgoingLinks = new ArrayList();
    private TransferSettleManager<AmqpLink> _receiverSettle = new TransferSettleManager();
    private TransferSettleManager<AmqpLink> _senderSettle = new TransferSettleManager();

    AmqpSession(AmqpConnectionHandler conn) {
        this._conn = conn;
    }

    public int getOutgoingIndex() {
        return 0;
    }

    public boolean addSenderLink(AmqpSenderLink link, SettleMode settleMode) {
        this.addOutgoingLink(link);
        link.setSession(this);
        this._conn.getWriter().attachSender(this, link, settleMode);
        return true;
    }

    public boolean addReceiverLink(AmqpReceiverLink link, DistributionMode distMode, SettleMode settleMode) {
        this.addOutgoingLink(link);
        link.setSession(this);
        this._conn.getWriter().attachReceiver(this, link, distMode, settleMode);
        return true;
    }

    void onAttach(AmqpLink link) {
        link.setSession(this);
        this.addIncomingLink(link);
        this.addOutgoingLink(link);
        this._conn.getWriter().attachReply(this, link);
        link.afterAttach();
    }

    void addIncomingLink(AmqpLink link) {
        int handle = link.getIncomingHandle();
        while (this._incomingLinks.size() <= handle) {
            this._incomingLinks.add(null);
        }
        this._incomingLinks.set(handle, link);
    }

    AmqpLink getIncomingLink(int handle) {
        return this._incomingLinks.get(handle);
    }

    private void addOutgoingLink(AmqpLink link) {
        for (int i = 0; i < this._outgoingLinks.size(); ++i) {
            if (this._outgoingLinks.get(i) != null) continue;
            this._outgoingLinks.set(i, link);
            link.setOutgoingHandle(i);
            return;
        }
        link.setOutgoingHandle(this._outgoingLinks.size());
        this._outgoingLinks.add(link);
    }

    public AmqpLink detachOutgoingLink(int handle) {
        AmqpLink link = this._outgoingLinks.get(handle);
        this._outgoingLinks.set(handle, null);
        return link;
    }

    public AmqpLink getOutgoingLink(int handle) {
        return this._outgoingLinks.get(handle);
    }

    AmqpLink findOutgoingLink(String name) {
        for (AmqpLink link : this._outgoingLinks) {
            if (link == null || !name.equals(link.getName())) continue;
            return link;
        }
        return null;
    }

    public void transfer(AmqpSenderLink link, long mid, SettleMode settleMode, InputStream is) {
        long deliveryId = this.addSenderSettle(link, mid, settleMode);
        this._conn.getWriter().transfer(this, link, deliveryId, settleMode, is);
    }

    private long addSenderSettle(AmqpLink link, long messageId, SettleMode settleMode) {
        return this._senderSettle.addDelivery(link, messageId, settleMode);
    }

    void onTransfer(FrameTransfer transfer, AmqpReader ain) throws IOException {
        int handle = transfer.getHandle();
        AmqpLink link = this.getIncomingLink(handle);
        link.onTransfer(transfer, ain);
    }

    long addReceiverSettle(AmqpLink link, long messageId, SettleMode settleMode) {
        return this._receiverSettle.addDelivery(link, messageId, settleMode);
    }

    public void accepted(long deliveryId) {
        DeliveryAccepted accepted = DeliveryAccepted.VALUE;
        boolean isSettled = false;
        this._conn.getWriter().sendDisposition(this, deliveryId, accepted, isSettled);
    }

    public void outgoingAccepted(long deliveryId) {
        DeliveryAccepted accepted = DeliveryAccepted.VALUE;
        boolean isSettled = true;
        this._conn.getWriter().sendDisposition(this, deliveryId, accepted, isSettled);
    }

    public void rejected(long deliveryId, String errorMessage) {
        DeliveryRejected rejected = new DeliveryRejected();
        if (errorMessage != null) {
            AmqpError error = new AmqpError();
            error.setCondition("rejected");
            error.setDescription(errorMessage);
            rejected.setError(error);
        }
        boolean isSettled = true;
        this._conn.getWriter().sendDisposition(this, deliveryId, rejected, isSettled);
    }

    public void modified(long deliveryId, boolean isFailed, boolean isUndeliverableHere) {
        DeliveryModified modified = new DeliveryModified();
        modified.setDeliveryFailed(isFailed);
        modified.setUndeliverableHere(isUndeliverableHere);
        boolean isSettled = false;
        this._conn.getWriter().sendDisposition(this, deliveryId, modified, isSettled);
    }

    public void released(long deliveryId) {
        DeliveryReleased released = DeliveryReleased.VALUE;
        boolean isSettled = false;
        this._conn.getWriter().sendDisposition(this, deliveryId, released, isSettled);
    }

    void flow(AmqpLink link, long deliveryCount, int credit) {
        this._conn.getWriter().sendFlow(this, link, deliveryCount, credit);
    }

    public void onFlow(FrameFlow flow) {
        int handle = flow.getHandle();
        AmqpLink link = this.getIncomingLink(handle);
        if (log.isLoggable(Level.FINER)) {
            log.finer(link + " onFlow(" + flow.getDeliveryCount() + "," + flow.getLinkCredit() + ")");
        }
        link.onFlow(flow);
    }

    public void onSenderDisposition(long xid, DeliveryState state, long first, long last) {
        this._receiverSettle.onDisposition(xid, state, first, last);
    }

    public void onReceiverDisposition(long xid, DeliveryState state, long first, long last) {
        this._senderSettle.onDisposition(xid, state, first, last);
    }

    public void onAccepted(long deliveryId) {
    }

    public void onRejected(long deliveryId, String msg) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getOutgoingIndex() + "]";
    }
}

