/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.AmqpException;
import com.caucho.amqp.common.AmqpLink;
import com.caucho.amqp.common.AmqpSenderLink;
import com.caucho.amqp.common.AmqpSession;
import com.caucho.amqp.io.AmqpAbstractFrame;
import com.caucho.amqp.io.AmqpFrameWriter;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.DeliveryState;
import com.caucho.amqp.io.FrameAttach;
import com.caucho.amqp.io.FrameBegin;
import com.caucho.amqp.io.FrameDisposition;
import com.caucho.amqp.io.FrameFlow;
import com.caucho.amqp.io.FrameOpen;
import com.caucho.amqp.io.FrameTransfer;
import com.caucho.amqp.io.LinkSource;
import com.caucho.amqp.io.LinkTarget;
import com.caucho.amqp.io.SaslMechanisms;
import com.caucho.amqp.io.SaslOutcome;
import com.caucho.message.DistributionMode;
import com.caucho.message.SettleMode;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmqpConnectionWriter {
    private static final Logger log = Logger.getLogger(AmqpConnectionWriter.class.getName());
    private WriteStream _os;
    private AmqpFrameWriter _fout;
    private AmqpWriter _aout;
    private boolean _isClosed;
    private boolean _isDisconnected;

    public AmqpConnectionWriter(WriteStream os) {
        if (os == null) {
            throw new NullPointerException();
        }
        this._os = os;
        this._fout = new AmqpFrameWriter(os);
        this._aout = new AmqpWriter();
        this._aout.initBase(this._fout);
    }

    public void writeVersion(int code) throws IOException {
        WriteStream os = this._os;
        os.write(65);
        os.write(77);
        os.write(81);
        os.write(80);
        os.write(code);
        os.write(1);
        os.write(0);
        os.write(0);
        os.flush();
    }

    public void writeOpen() {
        FrameOpen open = new FrameOpen();
        open.setContainerId("ResinAmqpServer");
        this.sendFrame(open);
    }

    public void writeBegin() {
        FrameBegin begin = new FrameBegin();
        this.sendFrame(begin);
    }

    public void attachSender(AmqpSession session, AmqpLink link, SettleMode settleMode) {
        FrameAttach attach = new FrameAttach();
        attach.setName(link.getName());
        attach.setHandle(link.getOutgoingHandle());
        attach.setRole(FrameAttach.Role.SENDER);
        switch (settleMode) {
            case ALWAYS: {
                attach.setSenderSettleMode(FrameAttach.SenderSettleMode.SETTLED);
                attach.setReceiverSettleMode(FrameAttach.ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                attach.setSenderSettleMode(FrameAttach.SenderSettleMode.MIXED);
                attach.setReceiverSettleMode(FrameAttach.ReceiverSettleMode.FIRST);
                break;
            }
            case EXACTLY_ONCE: {
                attach.setSenderSettleMode(FrameAttach.SenderSettleMode.MIXED);
                attach.setReceiverSettleMode(FrameAttach.ReceiverSettleMode.SECOND);
            }
        }
        attach.setProperties(link.getAttachProperties());
        LinkSource source = new LinkSource();
        source.setDynamicNodeProperties(link.getSourceProperties());
        attach.setSource(source);
        LinkTarget target = new LinkTarget();
        target.setAddress(link.getAddress());
        target.setDynamicNodeProperties(link.getTargetProperties());
        attach.setTarget(target);
        if (log.isLoggable(Level.FINER)) {
            log.finer(link + " attach(" + (Object)((Object)attach.getRole()) + "," + (Object)((Object)attach.getSenderSettleMode()) + "," + (Object)((Object)attach.getReceiverSettleMode()) + ")");
        }
        this.sendFrame(attach);
    }

    public void attachReceiver(AmqpSession session, AmqpLink link, DistributionMode distMode, SettleMode settleMode) {
        FrameAttach attach = new FrameAttach();
        attach.setName(link.getName());
        attach.setHandle(link.getOutgoingHandle());
        attach.setRole(FrameAttach.Role.RECEIVER);
        switch (settleMode) {
            case ALWAYS: {
                attach.setSenderSettleMode(FrameAttach.SenderSettleMode.SETTLED);
                attach.setReceiverSettleMode(FrameAttach.ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                attach.setSenderSettleMode(FrameAttach.SenderSettleMode.UNSETTLED);
                attach.setReceiverSettleMode(FrameAttach.ReceiverSettleMode.FIRST);
                break;
            }
            case EXACTLY_ONCE: {
                attach.setSenderSettleMode(FrameAttach.SenderSettleMode.UNSETTLED);
                attach.setReceiverSettleMode(FrameAttach.ReceiverSettleMode.SECOND);
            }
        }
        attach.setProperties(link.getAttachProperties());
        LinkSource source = new LinkSource();
        source.setAddress(link.getAddress());
        source.setDistributionMode(distMode);
        source.setDynamicNodeProperties(link.getSourceProperties());
        attach.setSource(source);
        LinkTarget target = new LinkTarget();
        target.setDynamicNodeProperties(link.getTargetProperties());
        attach.setTarget(target);
        if (log.isLoggable(Level.FINER)) {
            log.finer(link + " attach(" + (Object)((Object)attach.getRole()) + "," + (Object)((Object)attach.getSenderSettleMode()) + "," + (Object)((Object)attach.getReceiverSettleMode()) + ")");
        }
        this.sendFrame(attach);
    }

    public void attachReply(AmqpSession session, AmqpLink link) {
        FrameAttach attach = new FrameAttach();
        attach.setName(link.getName());
        attach.setHandle(link.getOutgoingHandle());
        LinkSource source = new LinkSource();
        source.setAddress(link.getAddress());
        attach.setSource(source);
        LinkTarget target = new LinkTarget();
        attach.setTarget(target);
        if (link.getRole() == FrameAttach.Role.SENDER) {
            attach.setRole(FrameAttach.Role.RECEIVER);
            attach.setInitialDeliveryCount(link.getDeliveryCount());
        } else {
            attach.setRole(FrameAttach.Role.SENDER);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(link + " attach(" + (Object)((Object)attach.getRole()) + "," + (Object)((Object)attach.getSenderSettleMode()) + "," + (Object)((Object)attach.getReceiverSettleMode()) + ")");
        }
        this.sendFrame(session.getOutgoingIndex(), attach);
    }

    public void transfer(AmqpSession session, AmqpSenderLink link, long deliveryId, SettleMode settleMode, InputStream is) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(link + " transfer(" + deliveryId + "," + (Object)((Object)settleMode) + ")");
            }
            boolean isSettled = settleMode == SettleMode.ALWAYS;
            this._fout.startFrame(0, session.getOutgoingIndex());
            FrameTransfer transfer = new FrameTransfer();
            transfer.setHandle(link.getOutgoingHandle());
            transfer.setSettled(isSettled);
            transfer.setDeliveryId(deliveryId);
            transfer.write(this._aout);
            this._fout.write(is);
            this._fout.finishFrame();
            this._fout.flush();
        }
        catch (IOException e) {
            throw new AmqpException(e);
        }
    }

    public void sendDisposition(AmqpSession session, long deliveryId, DeliveryState state, boolean isSettled) {
        FrameDisposition disposition = new FrameDisposition();
        disposition.setFirst(deliveryId);
        disposition.setLast(deliveryId);
        disposition.setState(state);
        disposition.setSettled(isSettled);
        if (log.isLoggable(Level.FINER)) {
            log.finer(session + " disposition(" + deliveryId + "," + state + ")");
        }
        this.sendFrame(disposition);
    }

    public void sendFlow(AmqpSession session, AmqpLink link, long deliveryCount, int credit) {
        FrameFlow flow = new FrameFlow();
        flow.setHandle(link.getOutgoingHandle());
        flow.setDeliveryCount(deliveryCount);
        flow.setLinkCredit(credit);
        if (log.isLoggable(Level.FINER)) {
            log.finer(link + " flow(" + deliveryCount + "," + credit + ")");
        }
        this.sendFrame(session.getOutgoingIndex(), flow);
    }

    public void disconnect() {
        this._isDisconnected = true;
    }

    public void sendFrame(AmqpAbstractFrame frame) {
        this.sendFrame(0, frame);
    }

    public void sendFrame(int channel, AmqpAbstractFrame frame) {
        try {
            this._fout.startFrame(0, channel);
            frame.write(this._aout);
            this._fout.finishFrame();
            this._fout.flush();
        }
        catch (IOException e) {
            throw new AmqpException(e);
        }
    }

    public void flush() {
        try {
            this._aout.flush();
            this._fout.flush();
            this._os.flush();
        }
        catch (IOException e) {
            throw new AmqpException(e);
        }
    }

    public void sendSaslChallenge() throws IOException {
        this._fout.startFrame(1);
        SaslMechanisms mechanisms = new SaslMechanisms();
        mechanisms.write(this._aout);
        this._fout.finishFrame();
        this._fout.startFrame(1);
        SaslOutcome outcome = new SaslOutcome();
        outcome.write(this._aout);
        this._fout.finishFrame();
    }
}

