/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractFrame;
import com.caucho.amqp.io.AmqpFrameHandler;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.DeliveryState;
import com.caucho.amqp.io.FrameAttach;
import java.io.IOException;

public class FrameDisposition
extends AmqpAbstractFrame {
    private FrameAttach.Role _role = FrameAttach.Role.SENDER;
    private long _first;
    private long _last;
    private boolean _isSettled;
    private DeliveryState _state;
    private boolean _isBatchable;

    public void setRole(FrameAttach.Role role) {
        this._role = role;
    }

    public FrameAttach.Role getRole() {
        return this._role;
    }

    public void setFirst(long first) {
        this._first = first;
    }

    public long getFirst() {
        return this._first;
    }

    public void setLast(long last) {
        this._last = last;
    }

    public long getLast() {
        return this._last;
    }

    public boolean isSettled() {
        return this._isSettled;
    }

    public void setSettled(boolean isSettled) {
        this._isSettled = isSettled;
    }

    public DeliveryState getState() {
        return this._state;
    }

    public void setState(DeliveryState state) {
        this._state = state;
    }

    public boolean isBatchable() {
        return this._isBatchable;
    }

    public long getDescriptorCode() {
        return 21L;
    }

    public FrameDisposition createInstance() {
        return new FrameDisposition();
    }

    public void invoke(AmqpReader fin, AmqpFrameHandler receiver) throws IOException {
        receiver.onDisposition(this);
    }

    public void readBody(AmqpReader in, int count) throws IOException {
        this._role = FrameAttach.Role.values()[in.readInt()];
        this._first = in.readInt();
        this._last = in.readInt();
        this._isSettled = in.readBoolean();
        this._state = in.readObject(DeliveryState.class);
        this._isBatchable = in.readBoolean();
    }

    public int writeBody(AmqpWriter out) throws IOException {
        out.writeUbyte(this._role.ordinal());
        out.writeUint((int)this._first);
        out.writeUint((int)this._last);
        out.writeBoolean(this._isSettled);
        if (this._state != null) {
            this._state.write(out);
        } else {
            out.writeNull();
        }
        out.writeBoolean(this._isBatchable);
        return 6;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._state + ",first=" + this._first + ",last=" + this._last + ")";
    }
}

