/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractFrame;
import com.caucho.amqp.io.AmqpFrameHandler;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.DeliveryState;
import com.caucho.amqp.io.FrameAttach;
import java.io.IOException;

public class FrameTransfer
extends AmqpAbstractFrame {
    public static final int CODE = 20;
    private int _handle;
    private long _deliveryId;
    private byte[] _deliveryTag;
    private int _messageFormat;
    private boolean _isSettled;
    private boolean _isMore;
    private FrameAttach.ReceiverSettleMode _receiverSettleMode = FrameAttach.ReceiverSettleMode.FIRST;
    private DeliveryState _state;
    private boolean _isResume;
    private boolean _isAborted;
    private boolean _isBatchable;

    public int getHandle() {
        return this._handle;
    }

    public void setHandle(int handle) {
        this._handle = handle;
    }

    public long getDeliveryId() {
        return this._deliveryId;
    }

    public void setDeliveryId(long deliveryId) {
        this._deliveryId = deliveryId;
    }

    public byte[] getDeliveryTag() {
        return this._deliveryTag;
    }

    public int getMessageFormat() {
        return this._messageFormat;
    }

    public boolean isSettled() {
        return this._isSettled;
    }

    public void setSettled(boolean isSettled) {
        this._isSettled = isSettled;
    }

    public boolean isMore() {
        return this._isMore;
    }

    public FrameAttach.ReceiverSettleMode getReceiverSettleMode() {
        return this._receiverSettleMode;
    }

    public DeliveryState getDeliveryState() {
        return this._state;
    }

    public boolean isResume() {
        return this._isResume;
    }

    public boolean isAborted() {
        return this._isAborted;
    }

    public boolean isBatchable() {
        return this._isBatchable;
    }

    public long getDescriptorCode() {
        return 20L;
    }

    public FrameTransfer createInstance() {
        return new FrameTransfer();
    }

    public void invoke(AmqpReader ain, AmqpFrameHandler handler) throws IOException {
        handler.onTransfer(ain, this);
    }

    public int writeBody(AmqpWriter out) throws IOException {
        out.writeUint(this._handle);
        out.writeUint((int)this._deliveryId);
        out.writeNull();
        out.writeUint(this._messageFormat);
        out.writeBoolean(this._isSettled);
        out.writeBoolean(this._isMore);
        out.writeUbyte(this._receiverSettleMode.ordinal());
        if (this._state != null) {
            this._state.write(out);
        } else {
            out.writeNull();
        }
        out.writeBoolean(this._isResume);
        out.writeBoolean(this._isAborted);
        out.writeBoolean(this._isBatchable);
        return 11;
    }

    public void readBody(AmqpReader in, int count) throws IOException {
        this._handle = in.readInt();
        this._deliveryId = in.readLong();
        this._deliveryTag = null;
        in.read();
        this._messageFormat = in.readInt();
        this._isSettled = in.readBoolean();
        this._isMore = in.readBoolean();
        this._receiverSettleMode = FrameAttach.ReceiverSettleMode.values()[in.readInt()];
        this._state = in.readObject(DeliveryState.class);
        this._isResume = in.readBoolean();
        this._isAborted = in.readBoolean();
        this._isBatchable = in.readBoolean();
    }
}

