/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.server;

import com.caucho.amqp.common.AmqpConnectionHandler;
import com.caucho.amqp.common.AmqpLinkFactory;
import com.caucho.amqp.common.AmqpReceiverLink;
import com.caucho.amqp.common.AmqpSenderLink;
import com.caucho.amqp.server.AmqpProtocol;
import com.caucho.message.DistributionMode;
import com.caucho.message.SettleMode;
import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public class AmqpServerConnection
extends AbstractProtocolConnection {
    private static final Logger log = Logger.getLogger(AmqpServerConnection.class.getName());
    private AmqpProtocol _amqp;
    private SocketLink _link;
    private State _state = State.NEW;
    private boolean _isSasl;
    private ServerLinkFactory _linkFactory;
    private AmqpConnectionHandler _handler;

    AmqpServerConnection(AmqpProtocol amqp, SocketLink link) {
        this._amqp = amqp;
        this._link = link;
    }

    public String getProtocolRequestURL() {
        return "amqp:";
    }

    public void init() {
    }

    SocketLink getLink() {
        return this._link;
    }

    ReadStream getReadStream() {
        return this._link.getReadStream();
    }

    WriteStream getWriteStream() {
        return this._link.getWriteStream();
    }

    public void onStartConnection() {
        this._state = State.NEW;
        this._linkFactory = new ServerLinkFactory();
    }

    public boolean handleRequest() throws IOException {
        switch (this._state) {
            case NEW: {
                this._handler = new AmqpConnectionHandler(this._linkFactory, this.getReadStream(), this.getWriteStream());
                if (!this._handler.getReader().readVersion()) {
                    return false;
                }
                if (this._isSasl) {
                    System.out.println("SASL:");
                    try {
                        this._handler.getWriter().sendSaslChallenge();
                        System.out.println("SENDED:");
                        this._handler.getReader().readVersion();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this._handler.getWriter().writeVersion(0);
                this._handler.getReader().readOpen();
                this._handler.getWriter().writeOpen();
                this._state = State.OPEN;
                return true;
            }
            case OPEN: {
                return this._handler.getReader().readFrame();
            }
        }
        System.out.println("UNKNOWN STATE: " + (Object)((Object)this._state));
        System.out.println("REQ:");
        return false;
    }

    public boolean handleResume() throws IOException {
        return false;
    }

    public boolean isWaitForRead() {
        return false;
    }

    public void onCloseConnection() {
        AmqpConnectionHandler handler = this._handler;
        this._handler = null;
        this._linkFactory = null;
        if (handler != null) {
            handler.closeConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServerLinkFactory
    implements AmqpLinkFactory {
        ServerLinkFactory() {
        }

        @Override
        public AmqpReceiverLink createReceiverLink(String name, String address, Map<String, Object> targetProperties) {
            return AmqpServerConnection.this._amqp.createReceiverLink(name, address, targetProperties);
        }

        @Override
        public AmqpSenderLink createSenderLink(String name, String address, DistributionMode distMode, SettleMode settleMode, Map<String, Object> sourceProperties) {
            return AmqpServerConnection.this._amqp.createSenderLink(name, address, distMode, settleMode, sourceProperties);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NEW,
        VERSION,
        OPEN;

    }
}

