/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.actor;

import com.caucho.bam.actor.AbstractActor;
import com.caucho.bam.actor.AbstractActorSender;
import com.caucho.bam.actor.Actor;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.bam.query.QueryActorFilter;

public class SimpleActorSender
extends AbstractActorSender
implements ActorSender {
    private Actor _actor;
    private Broker _broker;
    private String _clientAddress;

    public SimpleActorSender(String address, Broker broker) {
        this(address, (Actor)null, broker);
        this._clientAddress = address;
    }

    public SimpleActorSender(Actor next) {
        this(next.getAddress(), next, next.getBroker());
    }

    public SimpleActorSender(String address, Actor next, Broker broker) {
        super(address);
        if (next == null) {
            next = new DefaultActor();
        }
        this._actor = new QueryActorFilter(next, this.getQueryManager());
        this._broker = broker;
        this._clientAddress = next.getAddress();
    }

    public SimpleActorSender(Actor next, ManagedBroker broker, String uid, String resource) {
        this(uid + "/" + resource, next, broker);
        MultiworkerMailbox mailbox = new MultiworkerMailbox(next.getAddress(), this._actor, broker, 1);
        broker.addMailbox(next.getAddress(), mailbox);
    }

    public SimpleActorSender(ManagedBroker broker, String uid) {
        this(broker, uid, null);
    }

    public SimpleActorSender(ManagedBroker broker, String uid, String resource) {
        this(uid + "/" + resource, (Actor)null, broker);
        MultiworkerMailbox mailbox = new MultiworkerMailbox(null, this._actor, broker, 1);
        Mailbox stream = broker.createClient(mailbox, uid, resource);
        this._clientAddress = stream.getAddress();
    }

    public String getAddress() {
        if (this._actor != null) {
            return this._actor.getAddress();
        }
        return this._clientAddress;
    }

    public Actor getActor() {
        return this._actor;
    }

    public Broker getBroker() {
        return this._broker;
    }

    public void setBroker(Broker broker) {
        this._broker = broker;
    }

    protected ManagedBroker getManagedBroker() {
        return (ManagedBroker)this.getBroker();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getActor() + "]";
    }

    class DefaultActor
    extends AbstractActor {
        DefaultActor() {
        }

        public String getAddress() {
            return SimpleActorSender.this._clientAddress;
        }

        public Broker getBroker() {
            return SimpleActorSender.this.getBroker();
        }
    }
}

