/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.broker;

import com.caucho.bam.BamError;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.stream.MessageStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBrokerStream
implements MessageStream {
    private static final Logger log = Logger.getLogger(AbstractBrokerStream.class.getName());

    protected abstract Mailbox getMailbox(String var1);

    public String getAddress() {
        return this.getClass().getSimpleName() + ".localhost";
    }

    public void message(String to, String from, Serializable payload) {
        Mailbox toStream;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + ": message " + payload + "\n  {to: " + to + ", from:" + from + "}");
        }
        if ((toStream = this.getMailbox(to)) != null) {
            toStream.message(to, from, payload);
            return;
        }
        String msg = this + ": message to unknown actor" + "\n  to: " + to + "\n  from: " + from + "\n  payload: " + payload;
        if (log.isLoggable(Level.FINER)) {
            log.finer(msg);
        }
        BamError error = new BamError("cancel", "item-not-found", msg);
        Mailbox fromStream = this.getMailbox(from);
        if (fromStream != null) {
            fromStream.messageError(from, to, payload, error);
        }
    }

    public void messageError(String to, String from, Serializable payload, BamError error) {
        Mailbox toStream;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + ": messageError " + error + "\n  " + payload + "\n  {to: " + to + ", from:" + from + "}");
        }
        if ((toStream = this.getMailbox(to)) != null) {
            toStream.messageError(to, from, payload, error);
            return;
        }
        String msg = this + ": messageError to unknown actor to:" + to + "\n  from:" + from + "\n  payload:" + payload;
        if (log.isLoggable(Level.FINER)) {
            log.finer(msg);
        }
    }

    public void query(long id, String to, String from, Serializable payload) {
        Mailbox toStream;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + ": query(" + id + ") " + payload + "\n  {to: " + to + ", from:" + from + "}");
        }
        if ((toStream = this.getMailbox(to)) != null) {
            toStream.query(id, to, from, payload);
            return;
        }
        String msg = this + ": query(" + id + ") to unknown actor to:" + to + "\n  from:" + from + "\n  payload:" + payload;
        if (log.isLoggable(Level.FINER)) {
            log.finer(msg);
        }
        BamError error = new BamError("cancel", "item-not-found", msg);
        MessageStream fromStream = this.getQueryErrorStream(from);
        if (fromStream != null) {
            fromStream.queryError(id, from, to, payload, error);
        }
    }

    protected MessageStream getQueryErrorStream(String from) {
        return this.getMailbox(from);
    }

    public void queryResult(long id, String to, String from, Serializable payload) {
        Mailbox toStream;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + ": queryResult(" + id + ") " + payload + "\n  {to: " + to + ", from:" + from + "}");
        }
        if ((toStream = this.getMailbox(to)) != null) {
            toStream.queryResult(id, to, from, payload);
            return;
        }
        String msg = this + ": queryResult(qid=" + id + ") to unknown actor" + "\n  to: " + to + "\n  from: " + from + "\n  payload: " + payload;
        if (log.isLoggable(Level.FINER)) {
            log.finer(msg);
        }
    }

    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        Mailbox toStream;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + ": queryError(" + id + ") " + error + "\n  " + payload + "\n  {to: " + to + ", from:" + from + "}");
        }
        if ((toStream = this.getMailbox(to)) != null) {
            toStream.queryError(id, to, from, payload, error);
            return;
        }
        String msg = this + ": queryError(" + id + ") to unknown actor to:" + to + "\n  from:" + from + "\n  payload:" + payload;
        if (log.isLoggable(Level.FINER)) {
            log.finer(msg);
        }
    }

    public boolean isClosed() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

