/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.mailbox;

import com.caucho.bam.BamError;
import com.caucho.bam.QueueFullException;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.mailbox.MailboxQueue2;
import com.caucho.bam.packet.Message;
import com.caucho.bam.packet.MessageError;
import com.caucho.bam.packet.Packet;
import com.caucho.bam.packet.Query;
import com.caucho.bam.packet.QueryError;
import com.caucho.bam.packet.QueryResult;
import com.caucho.bam.stream.MessageStream;
import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.env.actor.ActorProcessor;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.L10N;
import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiworkerMailbox
implements Mailbox,
Closeable {
    private static final L10N L = new L10N(MultiworkerMailbox.class);
    private static final Logger log = Logger.getLogger(MultiworkerMailbox.class.getName());
    private final String _name;
    private final String _address;
    private final Broker _broker;
    private final MessageStream _actorStream;
    private final int _queueSize = 1024;
    private final MailboxQueue2[] _queues;
    private final Lifecycle _lifecycle = new Lifecycle();
    private final AtomicInteger _roundRobin = new AtomicInteger();

    public MultiworkerMailbox(MessageStream actorStream, Broker broker, int threadMax) {
        this(null, actorStream, broker, threadMax);
    }

    public MultiworkerMailbox(String address, MessageStream actorStream, Broker broker, int threadMax) {
        this._address = address;
        if (broker == null) {
            throw new NullPointerException(L.l("broker must not be null"));
        }
        if (actorStream == null) {
            throw new NullPointerException(L.l("actorStream must not be null"));
        }
        this._broker = broker;
        this._actorStream = actorStream;
        this._name = this._actorStream.getAddress() == null ? this._actorStream.getClass().getSimpleName() : this._actorStream.getAddress();
        this._queues = new MailboxQueue2[threadMax];
        for (int i = 0; i < threadMax; ++i) {
            this._queues[i] = this.createWorker();
        }
        this._lifecycle.toActive();
    }

    protected MailboxQueue2 createWorker() {
        return new MailboxQueue2(1024, this.createProcessor());
    }

    protected ActorProcessor<Packet> createProcessor() {
        return new PacketProcessor();
    }

    public int getThreadMax() {
        return this._queues.length;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (MailboxQueue2 mailbox : this._queues) {
            size += mailbox.getSize();
        }
        return size;
    }

    @Override
    public String getAddress() {
        if (this._address != null) {
            return this._address;
        }
        return this._actorStream.getAddress();
    }

    public boolean isPacketAvailable() {
        return false;
    }

    @Override
    public Broker getBroker() {
        return this._broker;
    }

    @Override
    public MessageStream getActorStream() {
        return this._actorStream;
    }

    @Override
    public void message(String to, String from, Serializable value) {
        try {
            this.enqueue(new Message(to, from, value));
        }
        catch (RuntimeException e) {
            log.warning(this + ": message " + value + " {to:" + to + ", from:" + from + "}" + "\n  " + e.toString());
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public void messageError(String to, String from, Serializable value, BamError error) {
        try {
            this.enqueue(new MessageError(to, from, value, error));
        }
        catch (RuntimeException e) {
            log.warning(this + ": messageError " + value + " {to:" + to + ", from:" + from + "}" + "\n  " + e.toString());
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public void query(long id, String to, String from, Serializable query) {
        if (!this._lifecycle.isActive()) {
            RemoteConnectionFailedException exn = new RemoteConnectionFailedException(L.l("{0} is closed", (Object)this));
            exn.fillInStackTrace();
            this.getBroker().queryError(id, from, to, query, BamError.create(exn));
            return;
        }
        try {
            this.enqueue(new Query(id, to, from, query));
        }
        catch (RuntimeException e) {
            log.warning(this + ": query " + query + " {to:" + to + ", from:" + from + "}" + "\n  " + e.toString());
            this.getBroker().queryError(id, from, to, query, BamError.create(e));
        }
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable value) {
        try {
            this.enqueue(new QueryResult(id, to, from, value));
        }
        catch (RuntimeException e) {
            log.warning(this + ": queryResult " + value + " {to:" + to + ", from:" + from + "}" + "\n  " + e.toString());
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public void queryError(long id, String to, String from, Serializable query, BamError error) {
        try {
            this.enqueue(new QueryError(id, to, from, query, error));
        }
        catch (RuntimeException e) {
            log.warning(this + ": queryError " + error + " {to:" + to + ", from:" + from + "}" + "\n  " + e.toString());
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected final void enqueue(Packet packet) {
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("{0} cannot accept packets because it's no longer active", (Object)this));
        }
        MailboxQueue2 workerQueue = this.findWorker();
        if (log.isLoggable(Level.FINEST)) {
            int size = workerQueue.getSize();
            log.finest(this + " enqueue(" + size + ") " + packet);
        }
        if (!workerQueue.offer(packet, false)) {
            workerQueue.wake();
            throw new QueueFullException("BAM queue is full size=" + workerQueue.getSize() + "\n  " + this + " " + packet);
        }
        workerQueue.wake();
    }

    private MailboxQueue2 findWorker() {
        for (MailboxQueue2 queue : this._queues) {
            if (!queue.isEmpty()) continue;
            return queue;
        }
        int roundRobin = this._roundRobin.incrementAndGet();
        int index = (roundRobin & Integer.MAX_VALUE) % this._queues.length;
        return this._queues[index];
    }

    @Override
    public void close() {
        this._lifecycle.toStop();
        for (MailboxQueue2 worker : this._queues) {
            worker.wake();
        }
        long expires = this.getCurrentTimeActual() + 2000L;
        while (!this.isQueueEmpty() && this.getCurrentTimeActual() < expires) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        for (MailboxQueue2 queue : this._queues) {
            queue.close();
        }
        this._lifecycle.toDestroy();
    }

    private boolean isQueueEmpty() {
        for (MailboxQueue2 queue : this._queues) {
            if (!queue.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected long getCurrentTimeActual() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean isClosed() {
        return this._lifecycle.isDestroying() || this._broker.isClosed();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PacketProcessor
    extends AbstractActorProcessor<Packet> {
        PacketProcessor() {
        }

        @Override
        public String getThreadName() {
            return MultiworkerMailbox.this._name + "-" + Thread.currentThread().getId();
        }

        @Override
        public void process(Packet packet) throws Exception {
            packet.dispatch(MultiworkerMailbox.this.getActorStream(), MultiworkerMailbox.this._broker);
        }

        @Override
        public void onProcessComplete() throws Exception {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + MultiworkerMailbox.this._name + "]";
        }
    }
}

