/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.mailbox;

import com.caucho.bam.BamError;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.stream.MessageStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PassthroughMailbox
implements Mailbox {
    private static final Logger log = Logger.getLogger(PassthroughMailbox.class.getName());
    private final String _address;
    private final Broker _broker;
    private final MessageStream _actorStream;

    public PassthroughMailbox(String address, MessageStream actorStream, Broker broker) {
        this._address = address;
        if (broker == null) {
            throw new NullPointerException();
        }
        this._broker = broker;
        if (actorStream == null) {
            throw new NullPointerException();
        }
        this._actorStream = actorStream;
    }

    public String getAddress() {
        return this._address;
    }

    public Broker getBroker() {
        return this._broker;
    }

    public int getSize() {
        return 0;
    }

    public boolean isClosed() {
        return this._actorStream.isClosed();
    }

    public MessageStream getActorStream() {
        return this._actorStream;
    }

    public void message(String to, String from, Serializable payload) {
        try {
            this._actorStream.message(to, from, payload);
        }
        catch (Throwable e) {
            this.getBroker().messageError(from, to, payload, BamError.create(e));
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void messageError(String to, String from, Serializable payload, BamError error) {
        try {
            this._actorStream.messageError(to, from, payload, error);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void query(long id, String to, String from, Serializable payload) {
        try {
            this._actorStream.query(id, to, from, payload);
        }
        catch (Throwable e) {
            this.getBroker().queryError(id, from, to, payload, BamError.create(e));
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void queryResult(long id, String to, String from, Serializable payload) {
        try {
            this._actorStream.queryResult(id, to, from, payload);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        try {
            this._actorStream.queryError(id, to, from, payload, error);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

