/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.proxy;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.SkeletonInvocationException;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.proxy.CallPayload;
import com.caucho.bam.proxy.ReplyCallback;
import com.caucho.bam.proxy.ReplyPayload;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.stream.MessageStream;
import com.caucho.util.Hex;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxySkeleton<S> {
    private static final L10N L = new L10N(ProxySkeleton.class);
    private static final Logger log = Logger.getLogger(ProxySkeleton.class.getName());
    private Class<?> _cl;
    private final HashMap<String, Method> _messageHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _messageErrorHandlers = new HashMap();
    private final HashMap<String, QueryInvoker> _queryHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _queryResultHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _queryErrorHandlers = new HashMap();

    private ProxySkeleton(Class<S> cl) {
        this._cl = cl;
        log.finest(L.l("{0} introspecting class {1}", (Object)this, (Object)cl.getName()));
        this.introspect(cl);
    }

    public static <T> ProxySkeleton<T> getSkeleton(Class<T> cl) {
        return new ProxySkeleton<T>(cl);
    }

    public void message(S actor, MessageStream fallback, String to, String from, Serializable payload) {
        if (!(payload instanceof CallPayload)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(actor + " message " + payload + " is unsupported");
            }
            return;
        }
        CallPayload call = (CallPayload)payload;
        Method handler = this._messageHandlers.get(call.getName());
        if (handler != null) {
            if (log.isLoggable(Level.FINER)) {
                this.logCall(-1L, to, from, call);
            }
            Object[] args = call.getArgs();
            Class<?>[] paramTypes = handler.getParameterTypes();
            if (args != null && args.length != paramTypes.length) {
                System.out.println("BAD-METHOD:" + handler);
                throw new IllegalArgumentException(L.l("'{0}.{1}' has an incorrect number of arguments (received {2} but expected {3})\n  {4}", (Object)actor.getClass().getSimpleName(), (Object)handler.getName(), (Object)(args != null ? args.length : 0), (Object)paramTypes.length, (Object)handler));
            }
            try {
                handler.invoke(actor, call.getArgs());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.message(to, from, payload);
        }
    }

    public void messageError(S actor, MessageStream fallback, String to, String from, Serializable payload, BamError error) {
        Method handler = payload != null ? this._messageErrorHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " messageError " + error + " " + payload + " {from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, to, from, payload, error);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.messageError(to, from, payload, error);
        }
    }

    public void query(S actor, MessageStream fallback, Broker broker, long id, String to, String from, Serializable payload) {
        if (!(payload instanceof CallPayload)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(actor + " query " + payload + " is unsupported");
            }
            broker.queryError(id, from, to, payload, new BamError("cancel", "feature-not-implemented", actor + " query " + payload + " is unsupported"));
            return;
        }
        CallPayload call = (CallPayload)payload;
        QueryInvoker handler = this._queryHandlers.get(call.getName());
        if (handler != null) {
            if (log.isLoggable(Level.FINER)) {
                this.logCall(id, to, from, call);
            }
            try {
                handler.invoke(actor, broker, id, to, from, call.getName(), call.getArgs());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.query(id, to, from, payload);
        }
    }

    private void logCall(long id, String to, String from, CallPayload call) {
        StringBuilder sb = new StringBuilder();
        sb.append("BAM ");
        sb.append(call.getName());
        sb.append(" (");
        Object[] args = call.getArgs();
        for (int i = 0; args != null && i < args.length; ++i) {
            Object arg;
            if (i != 0) {
                sb.append(", ");
            }
            if ((arg = args[i]) instanceof byte[]) {
                sb.append("byte[").append(Hex.toHex((byte[])args[i], 0, 4)).append("...]");
                continue;
            }
            sb.append(args[i]);
        }
        sb.append(")");
        sb.append("\n  {");
        if (id >= 0L) {
            sb.append("id: " + id + ", ");
        }
        sb.append("from:" + from + ", to:" + to + "}");
        log.finer(sb.toString());
    }

    public void queryResult(S actor, MessageStream fallback, long id, String to, String from, Serializable payload) {
        Method handler = payload != null ? this._queryResultHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " queryResult " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.queryResult(id, to, from, payload);
        }
    }

    public void queryError(S actor, MessageStream fallback, long id, String to, String from, Serializable payload, BamError error) {
        Method handler = payload != null ? this._queryErrorHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " queryError " + error + " " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload, error);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.queryError(id, to, from, payload, error);
        }
    }

    protected void introspect(Class<?> cl) {
        if (cl == null || cl == Object.class) {
            return;
        }
        this.introspect(cl.getSuperclass());
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isAssignableFrom(ReplyCallback.class)) {
                method.setAccessible(true);
                this._queryHandlers.put(method.getName(), new QueryShortReplyMethodInvoker(method));
                continue;
            }
            if (paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isAssignableFrom(QueryCallback.class)) {
                method.setAccessible(true);
                this._queryHandlers.put(method.getName(), new QueryShortQueryMethodInvoker(method));
                continue;
            }
            if (Void.TYPE.equals(method.getReturnType())) {
                method.setAccessible(true);
                this._messageHandlers.put(method.getName(), method);
                continue;
            }
            method.setAccessible(true);
            this._queryHandlers.put(method.getName(), new QueryMethodInvoker(method));
            this._messageHandlers.put(method.getName(), method);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cl.getName() + "]";
    }

    static class QueryQueryCallback
    implements QueryCallback {
        private final long _id;
        private final String _to;
        private final String _from;
        private final Broker _broker;

        QueryQueryCallback(long id, String to, String from, Broker broker) {
            this._id = id;
            this._to = to;
            this._from = from;
            this._broker = broker;
        }

        public void onQueryResult(String to, String from, Serializable payload) {
            this._broker.queryResult(this._id, this._from, this._to, payload);
        }

        public void onQueryError(String to, String from, Serializable payload, BamError error) {
            this._broker.queryError(this._id, this._from, this._to, payload, error);
        }
    }

    static class QueryShortQueryMethodInvoker
    extends QueryInvoker {
        private final Method _method;

        QueryShortQueryMethodInvoker(Method method) {
            this._method = method;
        }

        public void invoke(Object actor, Broker broker, long id, String to, String from, String methodName, Object[] args) throws IllegalAccessException, InvocationTargetException {
            Object[] param = new Object[args.length + 1];
            System.arraycopy(args, 0, param, 0, args.length);
            param[args.length] = new QueryQueryCallback(id, to, from, broker);
            this._method.invoke(actor, param);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryReplyCallback
    implements ReplyCallback<Object> {
        private final long _id;
        private final String _to;
        private final String _from;
        private final Broker _broker;

        QueryReplyCallback(long id, String to, String from, Broker broker) {
            this._id = id;
            this._to = to;
            this._from = from;
            this._broker = broker;
        }

        @Override
        public void onReply(Object result) {
            ReplyPayload reply = new ReplyPayload(result);
            this._broker.queryResult(this._id, this._from, this._to, reply);
        }

        @Override
        public void onError(BamError error) {
            this._broker.queryError(this._id, this._from, this._to, null, error);
        }
    }

    static class QueryShortReplyMethodInvoker
    extends QueryInvoker {
        private final Method _method;

        QueryShortReplyMethodInvoker(Method method) {
            this._method = method;
        }

        public void invoke(Object actor, Broker broker, long id, String to, String from, String methodName, Object[] args) throws IllegalAccessException, InvocationTargetException {
            Object[] param = new Object[args.length + 1];
            System.arraycopy(args, 0, param, 0, args.length);
            param[args.length] = new QueryReplyCallback(id, to, from, broker);
            this._method.invoke(actor, param);
        }
    }

    static class QueryShortMethodInvoker
    extends QueryInvoker {
        private final Method _method;

        QueryShortMethodInvoker(Method method) {
            this._method = method;
        }

        public void invoke(Object actor, Broker broker, long id, String to, String from, String methodName, Object[] args) throws IllegalAccessException, InvocationTargetException {
            Object result = this._method.invoke(actor, args);
            broker.queryResult(id, from, to, new ReplyPayload(result));
        }
    }

    static class QueryMethodInvoker
    extends QueryInvoker {
        private final Method _method;
        private final Class<?>[] _paramTypes;

        QueryMethodInvoker(Method method) {
            this._method = method;
            this._paramTypes = method.getParameterTypes();
        }

        public void invoke(Object actor, Broker broker, long id, String to, String from, String name, Object[] args) throws IllegalAccessException, InvocationTargetException {
            if (args != null && args.length != this._paramTypes.length) {
                throw new IllegalArgumentException(L.l("'{0}.{1}' has an incorrect number of arguments (received {2} but expected {3})\n  {4}", (Object)actor.getClass().getSimpleName(), (Object)name, (Object)(args != null ? args.length : 0), (Object)this._paramTypes.length, (Object)this._method));
            }
            Object result = this._method.invoke(actor, args);
            broker.queryResult(id, from, to, new ReplyPayload(result));
        }
    }

    static abstract class QueryInvoker {
        QueryInvoker() {
        }

        public abstract void invoke(Object var1, Broker var2, long var3, String var5, String var6, String var7, Object[] var8) throws IllegalAccessException, InvocationTargetException;
    }
}

