/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.proxy;

import com.caucho.bam.BamError;
import com.caucho.bam.proxy.ReplyCallback;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplyFutureCallback<T>
implements ReplyCallback<T> {
    private static final L10N L = new L10N(ReplyFutureCallback.class);
    private volatile ResultStateEnum _state = ResultStateEnum.WAITING;
    private volatile T _result;
    private volatile BamError _error;
    private volatile Thread _thread;

    @Override
    public void onReply(T result) {
        this._result = result;
        this._state = ResultStateEnum.REPLY;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public void onError(BamError error) {
        this._error = error;
        this._state = ResultStateEnum.ERROR;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public T get(long timeout) {
        switch (this._state) {
            case REPLY: {
                return this._result;
            }
            case ERROR: {
                throw this._error.createException();
            }
        }
        this._thread = Thread.currentThread();
        long expireTime = CurrentTime.getCurrentTimeActual() + timeout;
        while (this._state == ResultStateEnum.WAITING && CurrentTime.getCurrentTimeActual() <= expireTime) {
            long delta = expireTime - CurrentTime.getCurrentTimeActual();
            LockSupport.parkNanos(delta * 1000000L);
        }
        this._thread = null;
        switch (this._state) {
            case REPLY: {
                return this._result;
            }
            case ERROR: {
                throw this._error.createException();
            }
        }
        throw new IllegalStateException(L.l("future timeout {0}ms", timeout));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResultStateEnum {
        WAITING,
        REPLY,
        ERROR;

    }
}

