/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.router;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.BamActorRef;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.router.AbstractBamRouter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BamAllActorRouter
extends AbstractBamRouter {
    private static final Logger log = Logger.getLogger(BamAllActorRouter.class.getName());
    private final Broker _broker;
    private final ActorSender _sender;
    private final BamActorRef[] _actors;

    public BamAllActorRouter(ActorSender sender, BamActorRef ... actors) {
        this._broker = sender.getBroker();
        this._sender = sender;
        this._actors = actors;
    }

    public String getAddress() {
        return this.getActors()[0].getAddress();
    }

    public boolean isActive() {
        for (BamActorRef actor : this.getActors()) {
            if (!actor.isActive()) continue;
            return true;
        }
        return false;
    }

    public ActorSender getSender() {
        return this._sender;
    }

    protected BamActorRef[] getActors() {
        return this._actors;
    }

    public void message(String from, Serializable payload) {
        for (BamActorRef actor : this.getActors()) {
            if (!actor.isActive()) continue;
            actor.message(from, payload);
        }
    }

    public void query(long id, String from, Serializable payload) {
        BamActorRef[] actors = this.getActors();
        AllMethodScoreboard scoreboard = new AllMethodScoreboard(actors, id, from, payload);
        for (int i = 0; i < actors.length; ++i) {
            BamActorRef actor = actors[i];
            if (actor.isActive()) {
                this._sender.query(actor, payload, (QueryCallback)new AllMethodCallback(scoreboard, i));
                continue;
            }
            scoreboard.completeNotActive(i, actor);
        }
        if (actors.length == 0) {
            scoreboard.completeEmpty();
        }
    }

    class AllMethodCallback
    implements QueryCallback {
        private final AllMethodScoreboard _scoreboard;
        private final int _index;

        AllMethodCallback(AllMethodScoreboard scoreboard, int index) {
            this._scoreboard = scoreboard;
            this._index = index;
        }

        public void onQueryResult(String to, String from, Serializable result) {
            this._scoreboard.complete(this._index, result);
        }

        public void onQueryError(String to, String from, Serializable payload, BamError error) {
            log.finer(this + " " + error);
            this._scoreboard.complete(this._index, error);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._index + "," + this._scoreboard + "]";
        }
    }

    private class AllMethodScoreboard {
        private final long _id;
        private final String _from;
        private final Serializable _payload;
        private final boolean[] _isComplete;
        private final AtomicBoolean _isReplySent = new AtomicBoolean();
        private final AtomicReference<Serializable> _result = new AtomicReference();
        private final AtomicReference<BamError> _error = new AtomicReference();

        AllMethodScoreboard(BamActorRef[] actors, long id, String from, Serializable payload) {
            this._id = id;
            this._from = from;
            this._payload = payload;
            this._isComplete = new boolean[actors.length];
            this.checkComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(int index, Serializable result) {
            this._result.compareAndSet(null, result);
            boolean[] blArray = this._isComplete;
            synchronized (this._isComplete) {
                this._isComplete[index] = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.checkComplete();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(int index, BamError error) {
            this._error.compareAndSet(null, error);
            boolean[] blArray = this._isComplete;
            synchronized (this._isComplete) {
                this._isComplete[index] = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.checkComplete();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeNotActive(int index, BamActorRef actor) {
            if (log.isLoggable(Level.FINEST)) {
                log.finer(this + " cannot contact " + actor + " because not active");
            }
            boolean[] blArray = this._isComplete;
            synchronized (this._isComplete) {
                this._isComplete[index] = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.checkComplete();
                return;
            }
        }

        private void completeEmpty() {
            if (this._isComplete.length != 0) {
                throw new IllegalStateException();
            }
            this.checkComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkComplete() {
            boolean[] blArray = this._isComplete;
            synchronized (this._isComplete) {
                for (int i = 0; i < this._isComplete.length; ++i) {
                    if (this._isComplete[i]) continue;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (this._isReplySent.compareAndSet(false, true)) {
                    BamError error = this._error.get();
                    Serializable result = this._result.get();
                    if (error != null) {
                        BamAllActorRouter.this._broker.queryError(this._id, this._from, BamAllActorRouter.this._sender.getAddress(), this._payload, error);
                    } else {
                        BamAllActorRouter.this._broker.queryResult(this._id, this._from, BamAllActorRouter.this._sender.getAddress(), result);
                    }
                }
                return;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._id + "," + this._from + "," + BamAllActorRouter.this._sender + "]";
        }
    }
}

