/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.server.deploy.DeployClient;
import com.caucho.util.L10N;

public class ConfigUndeployCommand
extends AbstractRepositoryCommand {
    private static final L10N L = new L10N(ConfigUndeployCommand.class);

    protected void initBootOptions() {
        this.addValueOption("stage", "stage", "stage to deploy application to, defaults to production");
        this.addValueOption("version", "version", "version of application formatted as <major.minor.micro.qualifier>");
        this.addValueOption("m", "message", "commit message");
        super.initBootOptions();
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }

    public String getDescription() {
        return "undeploys configuration";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        String name = args.getArg("-name");
        CommitBuilder commit = new CommitBuilder();
        commit.type("config");
        String stage = args.getArg("-stage");
        if (stage != null) {
            commit.stage(stage);
        }
        if (name == null) {
            name = "resin";
        }
        commit.tagKey(name);
        String message = args.getArg("-m");
        if (message == null) {
            message = args.getArg("-message");
        }
        if (message == null) {
            message = "undeploy config from command line";
        }
        commit.message(message);
        commit.attribute("user", System.getProperty("user.name"));
        String version = args.getArg("-version");
        if (version != null) {
            DeployClient.fillInVersion(commit, version);
        }
        deployClient.undeploy(commit);
        System.out.println("Undeployed " + commit.getId() + " from " + deployClient.getUrl());
        return 0;
    }
}

