/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractDeployCommand;
import com.caucho.boot.ConfigDeployCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.config.ConfigException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;

public class DeployCommand
extends AbstractDeployCommand {
    private static final L10N L = new L10N(ConfigDeployCommand.class);

    protected void initBootOptions() {
        this.addValueOption("host", "host", "virtual host to make application available on");
        super.initBootOptions();
    }

    public String getDescription() {
        return "deploys an application";
    }

    protected Path getDeployPath(WatchdogArgs args) {
        String war = args.getDefaultArg();
        if (war == null) {
            throw new ConfigException(L.l("Cannot find .war argument in command line"));
        }
        Path path = Vfs.lookup(war);
        if (!war.endsWith(".war") && !path.isDirectory()) {
            throw new ConfigException(L.l("Deploy expects to be used with a *.war file or a directory at {0}", (Object)war));
        }
        return path;
    }

    protected CommitBuilder createCommitBuilder(WatchdogArgs args, Path path) {
        return DeployCommand.createWebAppCommit(args, path);
    }

    static CommitBuilder createWebAppCommit(WatchdogArgs args, Path path) {
        String host;
        CommitBuilder commit = new CommitBuilder();
        commit.type("webapp");
        String stage = args.getArg("-stage");
        if (stage != null) {
            commit.stage(stage);
        }
        if ((host = args.getArg("-host")) == null) {
            host = "default";
        }
        String name = DeployCommand.getWebAppName(args, path);
        commit.tagKey(host + "/" + name);
        return commit;
    }

    public String getUsageArgs() {
        return " <war-file>";
    }
}

