/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.L10N;

public class EnableCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(EnableCommand.class);

    public String getDescription() {
        return "enables a server for http/load-balancing";
    }

    public String getUsageArgs() {
        return " [<server>]";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient manager) throws BootArgumentException {
        String serverId = args.getDefaultArg();
        if (serverId == null) {
            serverId = args.getServerId();
        }
        if (serverId == null) {
            throw new ConfigException(L.l("{0}: -server is not specified", (Object)this.getName()));
        }
        String result = manager.enable(serverId);
        System.out.println(result);
        return 0;
    }
}

