/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.JmxCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.ListJmxQueryReply;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.L10N;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxListCommand
extends JmxCommand {
    private static final L10N L = new L10N(JmxListCommand.class);

    protected void initBootOptions() {
        this.addFlagOption("attributes", "prints MBean's attributes");
        this.addFlagOption("values", "prints attribute values");
        this.addFlagOption("operations", "prints operations");
        this.addFlagOption("all", "when <pattern> not specified sets the wildcard pattern (*:*)");
        this.addFlagOption("platform", "when <pattern> not specified sets the pattern to (java.lang:*)");
        super.initBootOptions();
    }

    public String getDescription() {
        return "lists the JMX MBeans in a Resin server";
    }

    public String getUsageArgs() {
        return " [<pattern>]";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        String pattern = args.getDefaultArg();
        if (pattern != null) {
            try {
                ObjectName.getInstance(pattern);
            }
            catch (MalformedObjectNameException e) {
                throw new ConfigException(L.l("invalid pattern `{0}': `{1}'", (Object)pattern, (Object)e.getMessage()));
            }
        }
        boolean isPrintAttributes = args.hasOption("-attributes");
        boolean isPrintOperations = args.hasOption("-operations");
        boolean isPrintValues = args.hasOption("-values");
        if (isPrintValues) {
            isPrintAttributes = true;
        }
        boolean isAll = args.hasOption("-all");
        boolean isPlatform = args.hasOption("-platform");
        ListJmxQueryReply result = managerClient.listJmx(pattern, isPrintAttributes, isPrintValues, isPrintOperations, isAll, isPlatform);
        StringBuilder message = new StringBuilder();
        for (ListJmxQueryReply.Bean bean : result.getBeans()) {
            message.append(bean.getName()).append('\n');
            if (isPrintAttributes || isPrintValues) {
                message.append("  attributes:\n");
                for (ListJmxQueryReply.Attribute attribute : bean.getAttributes()) {
                    message.append("    ").append(attribute.getInfo());
                    if (isPrintValues) {
                        message.append('=');
                        Object value = attribute.getValue();
                        message.append('=').append(value);
                    }
                    message.append('\n');
                }
            }
            if (!isPrintOperations) continue;
            message.append("  operations:\n");
            for (ListJmxQueryReply.Operation operation : bean.getOperations()) {
                message.append("    ").append(operation.getName());
                List<ListJmxQueryReply.Param> params = operation.getParams();
                if (params != null && params.size() > 0) {
                    message.append("\n      (\n");
                    for (int i = 0; i < params.size(); ++i) {
                        ListJmxQueryReply.Param param = params.get(i);
                        message.append("        ").append(i).append(":");
                        message.append(param.getType()).append(' ').append(param.getName());
                        if (param.getDescription() != null && !param.getDescription().isEmpty()) {
                            message.append(" /*").append(param.getDescription()).append("*/");
                        }
                        message.append('\n');
                    }
                    message.append("      )");
                } else {
                    message.append("()");
                }
                if (operation.getDescription() != null && !operation.getDescription().isEmpty()) {
                    message.append("/*").append(operation.getDescription()).append("*/");
                }
                message.append('\n');
            }
        }
        System.out.print(message.toString());
        return 0;
    }
}

