/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.security.CodeSource;
import java.security.SecureClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JniLoader
extends SecureClassLoader {
    private Path _resinHome;
    private JarPath _proJar;

    public JniLoader(Path resinHome) {
        super(JniLoader.class.getClassLoader());
        this._resinHome = resinHome;
        this._proJar = JarPath.create(this._resinHome.lookup("lib/pro.jar"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String className = name.replace('.', '/') + ".class";
        Path path = this._proJar.lookup(className);
        int length = (int)path.getLength();
        if (length > 0) {
            byte[] buffer = new byte[length];
            ReadStream is = null;
            try {
                Class<?> cl;
                is = path.openRead();
                is.readAll(buffer, 0, buffer.length);
                Class<?> clazz = cl = this.defineClass(name, buffer, 0, buffer.length, (CodeSource)null);
                {
                    Object var11_11 = null;
                    is.close();
                }
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    Object var11_12 = null;
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public String findLibrary(String name) {
        if (name.equals("resin")) {
            return this._resinHome.lookup("libexec").lookup("libresin.jnilib").getNativePath();
        }
        return super.findLibrary(name);
    }
}

