/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.types.Period;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.Date;

public class ListRestartsCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(ListRestartsCommand.class);

    protected void initBootOptions() {
        this.addValueOption("period", "period", "specifies look back period of time. e.g. '-period 1D' will list restarts since same time yesterday.");
        super.initBootOptions();
    }

    public String getDescription() {
        return "lists the most recent Resin server restart times";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        String message;
        String listPeriod = args.getArg("-period");
        if (listPeriod == null) {
            listPeriod = "7D";
        }
        long period = Period.toPeriod(listPeriod);
        Date since = new Date(CurrentTime.getCurrentTime() - period);
        Date[] restarts = managerClient.listRestarts(period);
        if (restarts.length == 0) {
            message = L.l("Server hasn't restarted since '{1}'", (Object)since);
        } else if (restarts.length == 1) {
            StringBuilder resultBuilder = new StringBuilder(L.l("Server started 1 time since '{0}'", (Object)since));
            resultBuilder.append("\n  ");
            resultBuilder.append(restarts[0]);
            message = resultBuilder.toString();
        } else {
            StringBuilder resultBuilder = new StringBuilder(L.l("Server restarted {0} times since '{1}'", (Object)restarts.length, (Object)since));
            for (Date restart : restarts) {
                resultBuilder.append("\n  ");
                resultBuilder.append(restart);
            }
            message = resultBuilder.toString();
        }
        System.out.println(message);
        return 0;
    }
}

