/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatusCommand
extends AbstractBootCommand {
    private static Logger _log;
    private static L10N _L;

    protected void initBootOptions() {
        this.addValueOption("server", "id", "select a configured server");
        this.addFlagOption("elastic-server", "use an elastic server in the cluster");
        super.initBootOptions();
    }

    public String getDescription() {
        return "watchdog and server status";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            String status = client.statusWatchdog();
            System.out.println(StatusCommand.L().l("Resin/{0} status for watchdog at {1}:{2}", (Object)VersionFactory.getVersion(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
            System.out.println(status);
        }
        catch (Exception e) {
            System.out.println(StatusCommand.L().l("Resin/{0} can't retrieve status of -server '{1}' for watchdog at {2}:{3}.\n{4}", (Object)VersionFactory.getVersion(), (Object)client.getId(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)e.toString()));
            StatusCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    public boolean isRetry() {
        return true;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(StatusCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(StatusCommand.class);
        }
        return _L;
    }
}

