/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.bam.Query;
import com.caucho.boot.ResultStatus;
import com.caucho.boot.WatchdogManager;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

class WatchdogActor {
    private static final L10N L = new L10N(WatchdogActor.class);
    private static final Logger log = Logger.getLogger(WatchdogActor.class.getName());
    private final WatchdogManager _manager;

    WatchdogActor(WatchdogManager manager) {
        this._manager = manager;
    }

    public String getResinHome() {
        return this._manager.getResinHome().getFullPath();
    }

    public ResultStatus start(String serverId, String[] argv) {
        try {
            serverId = this._manager.startServer(serverId, argv);
            String msg = L.l("{0}: started server '{1}'", (Object)this, (Object)serverId);
            return new ResultStatus(true, msg);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = e instanceof ConfigException ? e.getMessage() : L.l("{0}: start server failed because of exception\n  {1}'", (Object)this, (Object)e.toString());
            return new ResultStatus(false, msg);
        }
    }

    public ResultStatus status() {
        try {
            String result = this._manager.status();
            return new ResultStatus(true, result);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: status failed because of exception\n{1}'", (Object)this, (Object)e.toString());
            return new ResultStatus(false, msg);
        }
    }

    public ResultStatus stop(String serverId, String[] argv) {
        ResultStatus result;
        try {
            this._manager.stopServer(serverId, argv);
            String msg = L.l("{0}: stopped server='{1}'", (Object)this, (Object)serverId);
            result = new ResultStatus(true, msg);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: stop server='{1}' failed because of exception\n{2}'", (Object)this, (Object)serverId, (Object)e.toString());
            result = new ResultStatus(false, msg);
        }
        if (this._manager.isEmpty()) {
            new Thread(new Shutdown()).start();
        }
        return result;
    }

    public ResultStatus restart(String serverId, String[] argv) {
        ResultStatus result;
        try {
            this._manager.restartServer(serverId, argv);
            String msg = L.l("{0}: restarted server='{1}'", (Object)this, (Object)serverId);
            result = new ResultStatus(true, msg);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: restart server='{1}' failed because of exception\n{2}'", (Object)this, (Object)serverId, (Object)e.toString());
            result = new ResultStatus(false, msg);
        }
        if (this._manager.isEmpty()) {
            new Thread(new Shutdown()).start();
        }
        return result;
    }

    @Query
    public ResultStatus kill(String serverId) {
        ResultStatus result;
        try {
            this._manager.killServer(serverId);
            String msg = L.l("{0}: killed server='{1}'", (Object)this, (Object)serverId);
            result = new ResultStatus(true, msg);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: kill server='{1}' failed because of exception\n{2}'", (Object)this, (Object)serverId, (Object)e.toString());
            result = new ResultStatus(false, msg);
        }
        if (this._manager.isEmpty()) {
            new Thread(new Shutdown()).start();
        }
        return result;
    }

    @Query
    public ResultStatus shutdown() {
        try {
            String from = " unknown";
            log.info(this + " shutdown from " + from);
            String msg = L.l("{0}: shutdown", (Object)this);
            this._manager.shutdown();
            new Thread(new Shutdown()).start();
            return new ResultStatus(true, msg);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: shutdown failed because of exception\n{2}'", (Object)this, (Object)e.toString());
            return new ResultStatus(false, msg);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static class Shutdown
    implements Runnable {
        Shutdown() {
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

