/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.Boot;
import com.caucho.boot.OpenPort;
import com.caucho.boot.StartInfoMessage;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogChild;
import com.caucho.boot.WatchdogChildActor;
import com.caucho.boot.WatchdogChildTask;
import com.caucho.boot.WatchdogClient;
import com.caucho.bootjni.JniProcess;
import com.caucho.config.ConfigException;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.thread.ThreadPool;
import com.caucho.hmtp.HmtpLinkWorker;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.RotateLog;
import com.caucho.log.RotateStream;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchdogChildProcess {
    private static final L10N L = new L10N(WatchdogChildProcess.class);
    private static final Logger log = Logger.getLogger(WatchdogChildProcess.class.getName());
    private static Boot _jniBoot;
    private final String _id;
    private final ResinSystem _system;
    private final WatchdogChild _watchdog;
    private final Lifecycle _lifecycle = new Lifecycle();
    private WatchdogChildActor _watchdogActor;
    private WatchdogChildTask _task;
    private Socket _childSocket;
    private AtomicReference<Process> _processRef = new AtomicReference();
    private OutputStream _stdOs;
    private int _pid;
    private long _startTime;
    private int _status = -1;
    private String _exitMessage;
    private ExitCode _exitCode;

    WatchdogChildProcess(String id, ResinSystem system, WatchdogChild watchdog, WatchdogChildTask task) {
        this._id = id;
        this._system = system;
        this._watchdog = watchdog;
        this._task = task;
    }

    int getPid() {
        return this._pid;
    }

    public String getId() {
        return this._id;
    }

    Serializable queryGet(Serializable payload) {
        if (this._watchdogActor != null) {
            return this._watchdogActor.query(payload);
        }
        return null;
    }

    void message(Serializable payload) {
        if (this._watchdogActor != null) {
            this._watchdogActor.message(payload);
        }
    }

    public int getStatus() {
        return this._status;
    }

    public String getExitMessage() {
        return this._exitMessage;
    }

    public void setShutdownMessage(String msg) {
        this._task.setShutdownMessage(msg);
    }

    public long getUptime() {
        long now = CurrentTime.getCurrentTime();
        long start = this._startTime;
        if (this._startTime > 0L) {
            return now - start;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block61: {
            Object e22;
            Socket s;
            ServerSocket ss;
            WriteStream jvmOut;
            Thread thread;
            block57: {
                block56: {
                    if (!this._lifecycle.toActive()) {
                        return;
                    }
                    EnvironmentClassLoader envLoader = EnvironmentClassLoader.create(this._system.getClassLoader());
                    thread = Thread.currentThread();
                    jvmOut = null;
                    ss = null;
                    s = null;
                    this._startTime = CurrentTime.getCurrentTime();
                    thread.setContextClassLoader(envLoader);
                    envLoader.start();
                    ss = new ServerSocket(0, 5, InetAddress.getByName("127.0.0.1"));
                    int port = ss.getLocalPort();
                    log.warning("Watchdog starting Resin[" + this._watchdog.getId() + "]");
                    jvmOut = this.createJvmOut();
                    Process process = this.createProcess(port, jvmOut);
                    if (process == null) break block56;
                    this._processRef.compareAndSet(null, process);
                    this._pid = process instanceof JniProcess ? ((JniProcess)process).getPid() : 0;
                    InputStream stdIs = process.getInputStream();
                    this._stdOs = process.getOutputStream();
                    WatchdogProcessLogThread logThread = new WatchdogProcessLogThread(stdIs, jvmOut);
                    ThreadPool.getCurrent().start(logThread);
                    s = this.connectToChild(ss);
                    this.message(new StartInfoMessage(this._watchdog.isRestart(), this._watchdog.getRestartMessage(), this._watchdog.getPreviousExitCode(), this._task.getShutdownMessage()));
                    this._status = process.waitFor();
                    this.logStatus(this._status);
                }
                Object var11_13 = null;
                this._startTime = 0L;
                if (ss == null) break block57;
                try {
                    ss.close();
                }
                catch (Throwable e22) {
                    // empty catch block
                }
            }
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable e22) {
                log.log(Level.FINER, ((Throwable)e22).toString(), (Throwable)e22);
            }
            this.kill();
            if (jvmOut != null && !this._watchdog.isConsole()) {
                try {
                    e22 = jvmOut;
                    synchronized (e22) {
                        jvmOut.close();
                    }
                }
                catch (Exception e22) {
                    // empty catch block
                }
            }
            WatchdogChildProcess watchdogChildProcess = this;
            synchronized (watchdogChildProcess) {
                if (this._status < 0) {
                    this._status = 666;
                }
                this.notifyAll();
            }
            thread.setContextClassLoader(this._system.getClassLoader());
            {
                break block61;
                catch (Exception e3) {
                    System.err.println(e3.getMessage());
                    log.log(Level.WARNING, e3.toString(), e3);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e1) {
                    }
                    Object var11_14 = null;
                    this._startTime = 0L;
                    if (ss != null) {
                        try {
                            ss.close();
                        }
                        catch (Throwable e22) {
                            // empty catch block
                        }
                    }
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (Throwable e22) {
                        log.log(Level.FINER, ((Throwable)e22).toString(), (Throwable)e22);
                    }
                    this.kill();
                    if (jvmOut != null && !this._watchdog.isConsole()) {
                        try {
                            e22 = jvmOut;
                            synchronized (e22) {
                                jvmOut.close();
                            }
                        }
                        catch (Exception e22) {
                            // empty catch block
                        }
                    }
                    WatchdogChildProcess watchdogChildProcess2 = this;
                    synchronized (watchdogChildProcess2) {
                        if (this._status < 0) {
                            this._status = 666;
                        }
                        this.notifyAll();
                    }
                    thread.setContextClassLoader(this._system.getClassLoader());
                    break block61;
                }
                catch (Throwable e4) {
                    log.log(Level.WARNING, e4.toString(), e4);
                    Object var11_15 = null;
                    this._startTime = 0L;
                    if (ss != null) {
                        try {
                            ss.close();
                        }
                        catch (Throwable e22) {
                            // empty catch block
                        }
                    }
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (Throwable e22) {
                        log.log(Level.FINER, ((Throwable)e22).toString(), (Throwable)e22);
                    }
                    this.kill();
                    if (jvmOut != null && !this._watchdog.isConsole()) {
                        try {
                            e22 = jvmOut;
                            synchronized (e22) {
                                jvmOut.close();
                            }
                        }
                        catch (Exception e22) {
                            // empty catch block
                        }
                    }
                    WatchdogChildProcess watchdogChildProcess3 = this;
                    synchronized (watchdogChildProcess3) {
                        if (this._status < 0) {
                            this._status = 666;
                        }
                        this.notifyAll();
                    }
                    thread.setContextClassLoader(this._system.getClassLoader());
                }
            }
            catch (Throwable throwable) {
                Throwable e22;
                Object var11_16 = null;
                this._startTime = 0L;
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Throwable e22) {
                    log.log(Level.FINER, e22.toString(), e22);
                }
                this.kill();
                if (jvmOut != null && !this._watchdog.isConsole()) {
                    try {
                        e22 = jvmOut;
                        synchronized (e22) {
                            jvmOut.close();
                        }
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                WatchdogChildProcess watchdogChildProcess4 = this;
                synchronized (watchdogChildProcess4) {
                    if (this._status < 0) {
                        this._status = 666;
                    }
                    this.notifyAll();
                }
                thread.setContextClassLoader(this._system.getClassLoader());
                throw throwable;
            }
        }
    }

    private void logStatus(int status) {
        String type = "unknown";
        String code = " (exit code=" + status + ")";
        this._exitCode = ExitCode.UNKNOWN;
        if (status == 0) {
            type = "normal exit";
            this._exitCode = ExitCode.OK;
        } else if (status >= 0 && status < ExitCode.values().length) {
            this._exitCode = ExitCode.values()[status];
            type = this._exitCode.toString();
        } else if (status >= 128 && status < 160) {
            this._exitCode = ExitCode.SIGNAL;
            switch (status - 128) {
                case 1: {
                    type = "SIGHUP";
                    break;
                }
                case 2: {
                    type = "SIGINT";
                    break;
                }
                case 3: {
                    type = "SIGQUIT";
                    break;
                }
                case 4: {
                    type = "SIGILL";
                    break;
                }
                case 5: {
                    type = "SIGTRAP";
                    break;
                }
                case 6: {
                    type = "SIGABRT";
                    break;
                }
                case 7: {
                    type = "SIGBUS";
                    break;
                }
                case 8: {
                    type = "SIGFPE";
                    break;
                }
                case 9: {
                    type = "SIGKILL";
                    break;
                }
                case 10: {
                    type = "SIGUSR1";
                    break;
                }
                case 11: {
                    type = "SIGSEGV";
                    break;
                }
                case 12: {
                    type = "SIGUSR2";
                    break;
                }
                case 13: {
                    type = "SIGPIPE";
                    break;
                }
                case 14: {
                    type = "SIGALRM";
                    break;
                }
                case 15: {
                    type = "SIGTERM";
                    break;
                }
                case 19: {
                    type = "SIGSTOP";
                    break;
                }
                default: {
                    type = "signal=" + (status - 128);
                }
            }
            code = " (signal=" + (status - 128) + ")";
        }
        String msg = "Watchdog detected close of Resin[" + this._watchdog.getId() + ",pid=" + this._pid + "]" + "\n  exit reason: " + type + code;
        log.warning(msg);
        this._exitMessage = msg;
    }

    void stop() {
        this._lifecycle.toDestroy();
        if (this._watchdogActor != null) {
            this._watchdogActor.sendShutdown();
        }
    }

    void kill() {
        this._lifecycle.toDestroy();
        Process process = this._processRef.getAndSet(null);
        if (process != null) {
            try {
                process.destroy();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        OutputStream stdOs = this._stdOs;
        this._stdOs = null;
        if (stdOs != null) {
            try {
                stdOs.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        Socket childSocket = this._childSocket;
        this._childSocket = null;
        if (childSocket != null) {
            try {
                childSocket.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (process != null) {
            try {
                process.waitFor();
            }
            catch (Exception e) {
                log.log(Level.INFO, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForExit() {
        WatchdogChildProcess watchdogChildProcess = this;
        synchronized (watchdogChildProcess) {
            if (this._status < 0) {
                try {
                    this.wait(60000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Socket connectToChild(ServerSocket ss) throws IOException {
        Socket s = null;
        try {
            block7: {
                try {
                    ss.setSoTimeout(60000);
                    for (int i = 0; this._lifecycle.isActive() && i < 120 && s == null; ++i) {
                        try {
                            s = ss.accept();
                            continue;
                        }
                        catch (SocketTimeoutException e) {
                            // empty catch block
                        }
                    }
                    if (s == null) break block7;
                    this._childSocket = s;
                    this.startWatchdogActor(s);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var6_7 = null;
                    ss.close();
                    return s;
                }
            }
            Object var6_6 = null;
            ss.close();
            return s;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ss.close();
            throw throwable;
        }
    }

    private void startWatchdogActor(Socket s) throws IOException {
        InputStream watchdogIs = s.getInputStream();
        OutputStream watchdogOs = s.getOutputStream();
        this._watchdogActor = new WatchdogChildActor(this);
        HmtpLinkWorker link = new HmtpLinkWorker(this._watchdogActor, watchdogIs, watchdogOs);
        try {
            ThreadPool.getCurrent().schedule(link);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Process createProcess(int socketPort, WriteStream out) throws IOException {
        ArrayList<String> jvmArgs;
        HashMap<String, String> env;
        Path processPwd;
        block27: {
            Boot boot;
            Path chroot = this._watchdog.getChroot();
            processPwd = this._watchdog.getPwd();
            env = this.buildEnv();
            jvmArgs = this.buildJvmArgs();
            ArrayList<String> resinArgs = this.buildResinArgs(socketPort);
            this.addCommandLineArguments(jvmArgs, resinArgs);
            jvmArgs.add("com.caucho.server.resin.Resin");
            jvmArgs.addAll(resinArgs);
            if (this._watchdog.isVerbose()) {
                this.logVerboseArguments(out, jvmArgs);
                this.logVerboseEnvironment(out, env);
            }
            if ((boot = this.getJniBoot()) != null) {
                ArrayList<QServerSocket> boundSockets;
                block26: {
                    Process process;
                    boot.clearSaveOnExec();
                    boundSockets = new ArrayList<QServerSocket>();
                    try {
                        Process process2;
                        if (this._watchdog.getUserName() != null) {
                            for (OpenPort port : this._watchdog.getPorts()) {
                                QServerSocket ss = port.bindForWatchdog();
                                if (ss == null) continue;
                                boundSockets.add(ss);
                                if (ss.setSaveOnExec()) {
                                    jvmArgs.add("-port");
                                    jvmArgs.add(String.valueOf(ss.getSystemFD()));
                                    jvmArgs.add(String.valueOf(port.getAddress()));
                                    jvmArgs.add(String.valueOf(port.getPort()));
                                    continue;
                                }
                                ss.close();
                            }
                        }
                        String chrootPath = null;
                        if (chroot != null) {
                            chrootPath = chroot.getNativePath();
                        }
                        if ((process2 = boot.exec(jvmArgs, env, chrootPath, processPwd.getNativePath(), this._watchdog.getUserName(), this._watchdog.getGroupName())) == null) break block26;
                        process = process2;
                        Object var14_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        for (int i = 0; i < boundSockets.size(); ++i) {
                            try {
                                ((QServerSocket)boundSockets.get(i)).close();
                                continue;
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    for (int i = 0; i < boundSockets.size(); ++i) {
                        try {
                            ((QServerSocket)boundSockets.get(i)).close();
                            continue;
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                    }
                    return process;
                }
                Object var14_16 = null;
                for (int i = 0; i < boundSockets.size(); ++i) {
                    try {
                        ((QServerSocket)boundSockets.get(i)).close();
                        continue;
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
                {
                    break block27;
                    catch (ConfigException e) {
                        log.warning(e.getMessage());
                        Object var14_17 = null;
                        for (int i = 0; i < boundSockets.size(); ++i) {
                            try {
                                ((QServerSocket)boundSockets.get(i)).close();
                                continue;
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                        break block27;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var14_18 = null;
                        for (int i = 0; i < boundSockets.size(); ++i) {
                            try {
                                ((QServerSocket)boundSockets.get(i)).close();
                                continue;
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        if (this._watchdog.getUserName() != null) {
            if (this._watchdog.isConsole()) {
                throw new ConfigException(L.l("<user-name> requires compiled JNI started with 'start'.  Resin cannot use <user-name> when started as a console process."));
            }
            throw new ConfigException(L.l("<user-name> '{0}' requires compiled JNI and a valid operating-system user name.", (Object)this._watchdog.getUserName()));
        }
        if (this._watchdog.getGroupName() != null) {
            if (this._watchdog.isConsole()) {
                throw new ConfigException(L.l("<group-name> requires compiled JNI started with 'start'.  Resin cannot use <group-name> when started as a console process."));
            }
            throw new ConfigException(L.l("<group-name> requires compiled JNI."));
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File(processPwd.getNativePath()));
        builder.environment().putAll(env);
        builder = builder.command(jvmArgs);
        builder.redirectErrorStream(true);
        return builder.start();
    }

    private HashMap<String, String> buildEnv() throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(System.getenv());
        Path resinHome = this._watchdog.getResinHome();
        ArrayList<String> classPathList = new ArrayList<String>();
        classPathList.addAll(this._watchdog.getJvmClasspath());
        String classPath = WatchdogArgs.calculateClassPath(classPathList, resinHome);
        env.put("CLASSPATH", classPath);
        if (this._watchdog.is64bit()) {
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH", resinHome.lookup("libexec64").getNativePath());
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH_64", resinHome.lookup("libexec64").getNativePath());
            WatchdogClient.appendEnvPath(env, "DYLD_LIBRARY_PATH", resinHome.lookup("libexec64").getNativePath());
            if (CauchoSystem.isWindows()) {
                WatchdogClient.appendEnvPath(env, "Path", resinHome.lookup("win64").getNativePath());
            }
        } else {
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH", resinHome.lookup("libexec").getNativePath());
            WatchdogClient.appendEnvPath(env, "DYLD_LIBRARY_PATH", resinHome.lookup("libexec").getNativePath());
            if (CauchoSystem.isWindows()) {
                WatchdogClient.appendEnvPath(env, "Path", resinHome.lookup("win32").getNativePath());
            }
        }
        return env;
    }

    private ArrayList<String> buildJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add(this._watchdog.getJavaExe());
        boolean isEndorsed = false;
        for (String arg : this._watchdog.getJvmArgs()) {
            if (!arg.startsWith("-Djava.class.path")) {
                jvmArgs.add(arg);
            }
            if (!arg.startsWith("-Djava.endorsed.dirs")) continue;
            isEndorsed = true;
        }
        jvmArgs.add("-Dresin.server=" + this._id);
        jvmArgs.add("-Djava.util.logging.manager=com.caucho.log.LogManagerImpl");
        String systemClassLoader = this._watchdog.getSystemClassLoader();
        if (systemClassLoader != null && !"".equals(systemClassLoader)) {
            jvmArgs.add("-Djava.system.class.loader=" + systemClassLoader);
        }
        Path resinHome = this._watchdog.getResinHome();
        Path resinRoot = this._watchdog.getResinRoot();
        if (!isEndorsed) {
            String endorsed = System.getProperty("java.endorsed.dirs");
            String resinEndorsed = resinHome.getNativePath() + File.separator + "endorsed";
            resinEndorsed = resinEndorsed + File.pathSeparator + resinRoot.getNativePath() + File.separator + "endorsed";
            endorsed = endorsed != null ? endorsed + File.pathSeparator + resinEndorsed : resinEndorsed;
            jvmArgs.add("-Djava.endorsed.dirs=" + endorsed);
        }
        jvmArgs.add("-Djavax.management.builder.initial=com.caucho.jmx.MBeanServerBuilderImpl");
        jvmArgs.add("-Djava.awt.headless=true");
        jvmArgs.add("-Dresin.home=" + resinHome.getFullPath());
        if (!this._watchdog.hasXss()) {
            jvmArgs.add("-Xss1m");
        }
        if (!this._watchdog.hasXmx()) {
            jvmArgs.add("-Xmx256m");
        }
        if (CauchoSystem.isWindows()) {
            jvmArgs.add("-Xrs");
        }
        if (this._task.getPreviousExitCode() != null) {
            jvmArgs.add("-Dresin.exit.code=" + this._task.getPreviousExitCode().toString());
        }
        if (this._task.getShutdownMessage() != null) {
            jvmArgs.add("-Dresin.exit.message=" + this._task.getShutdownMessage());
        }
        String[] argv = this._watchdog.getArgv();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.startsWith("-D") || arg.startsWith("-X")) {
                jvmArgs.add(arg);
                continue;
            }
            if (arg.startsWith("-J")) {
                jvmArgs.add(arg.substring(2));
                continue;
            }
            if (arg.equals("-d64") || arg.equals("-d32")) {
                jvmArgs.add(arg);
                continue;
            }
            if ("--debug-port".equals(arg) || "-debug-port".equals(arg)) {
                jvmArgs.add("-Xdebug");
                jvmArgs.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + argv[i + 1]);
                ++i;
                continue;
            }
            if (!"--jmx-port".equals(arg) && !"-jmx-port".equals(arg)) continue;
            jvmArgs.add("-Dcom.sun.management.jmxremote.port=" + argv[i + 1]);
            jvmArgs.add("-Dcom.sun.management.jmxremote.authenticate=false");
            jvmArgs.add("-Dcom.sun.management.jmxremote.ssl=false");
            ++i;
        }
        if (!jvmArgs.contains("-d32") && !jvmArgs.contains("-d64") && this._watchdog.is64bit() && !CauchoSystem.isWindows()) {
            jvmArgs.add("-d64");
        }
        if (!(jvmArgs.contains("-server") || jvmArgs.contains("-client") || CauchoSystem.isWindows())) {
            jvmArgs.add("-server");
        }
        return jvmArgs;
    }

    private ArrayList<String> buildResinArgs(int socketPort) {
        ArrayList<String> resinArgs = new ArrayList<String>();
        Path resinRoot = this._watchdog.getResinRoot();
        if (resinRoot != null) {
            resinArgs.add("--root-directory");
            resinArgs.add(resinRoot.getFullPath());
        }
        if (this._watchdog.getResinConf() != null) {
            resinArgs.add("-conf");
            resinArgs.add(this._watchdog.getResinConf().getNativePath());
        }
        if (this._watchdog.getId() != null) {
            resinArgs.add("-server");
            if ("".equals(this._watchdog.getId()) || this._watchdog.getId() == null) {
                resinArgs.add("default");
            } else {
                resinArgs.add(this._watchdog.getId());
            }
        }
        if (this._watchdog.isElasticServer()) {
            resinArgs.add("--elastic-server");
            if (this._watchdog.getElasticServerCluster() == null) {
                throw new IllegalStateException(this._watchdog.toString());
            }
            resinArgs.add("--cluster");
            resinArgs.add(this._watchdog.getElasticServerCluster());
            if (this._watchdog.getElasticServerPort() == 0) {
                throw new IllegalStateException(this._watchdog.toString());
            }
            resinArgs.add("--elastic-server-port");
            resinArgs.add(Integer.toString(this._watchdog.getElasticServerPort()));
        }
        resinArgs.add("-socketwait");
        resinArgs.add(String.valueOf(socketPort));
        return resinArgs;
    }

    private void addCommandLineArguments(ArrayList<String> jvmArgs, ArrayList<String> resinArgs) {
        String[] argv = this._watchdog.getArgv();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-conf")) {
                ++i;
                continue;
            }
            if (argv[i].startsWith("-Djava.class.path=")) continue;
            if (argv[i].startsWith("-J")) {
                jvmArgs.add(argv[i].substring(2));
                continue;
            }
            if (argv[i].startsWith("-Djava.class.path") || argv[i].startsWith("-D") || argv[i].startsWith("-X") || argv[i].equals("-d64") || argv[i].startsWith("-d32")) continue;
            if (CauchoSystem.isWindows() && "".equals(argv[i])) {
                resinArgs.add("\"\"");
                continue;
            }
            resinArgs.add(argv[i]);
        }
    }

    private void logVerboseArguments(WriteStream out, ArrayList<String> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                out.print("  ");
            }
            out.print(list.get(i));
            if (i + 1 < list.size()) {
                out.println(" \\");
                continue;
            }
            out.println();
        }
    }

    private void logVerboseEnvironment(WriteStream out, Map<String, String> env) throws IOException {
        for (Map.Entry<String, String> envEntry : env.entrySet()) {
            String key = envEntry.getKey();
            String value = envEntry.getValue();
            if ("CLASSPATH".equals(key) || "LD_LIBRARY_PATH".equals(key) || "DYLD_LIBRARY_PATH".equals(key)) {
                out.println(key + ": ");
                int len = (key + ": ").length();
                for (String v : value.split("[" + File.pathSeparatorChar + "]")) {
                    for (int i = 0; i < len; ++i) {
                        out.print(" ");
                    }
                    out.println(v);
                }
                continue;
            }
            out.println("" + key + ": " + value);
        }
    }

    Boot getJniBoot() {
        if (_jniBoot != null) {
            return _jniBoot.isValid() ? _jniBoot : null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.bootjni.JniBoot", false, loader);
            _jniBoot = (Boot)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.fine(e.toString());
        }
        catch (IllegalStateException e) {
            log.fine(e.toString());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return _jniBoot != null && _jniBoot.isValid() ? _jniBoot : null;
    }

    private WriteStream createJvmOut() throws IOException {
        if (this._watchdog.isConsole()) {
            return Vfs.openWrite(System.out);
        }
        Path jvmPath = this._watchdog.getLogPath();
        try {
            Path dir = jvmPath.getParent();
            if (!dir.exists()) {
                String groupName;
                dir.mkdirs();
                String userName = this._watchdog.getUserName();
                if (userName != null) {
                    dir.changeOwner(userName);
                }
                if ((groupName = this._watchdog.getGroupName()) != null) {
                    dir.changeGroup(groupName);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        RotateLog log = new RotateLog();
        log.setPath(jvmPath);
        log.setRolloverSizeBytes(0x4000000L);
        if (this._watchdog.getStdoutLog() != null) {
            this._watchdog.getStdoutLog().configure(log);
        }
        log.init();
        RotateStream rotateStream = log.getRotateStream();
        return rotateStream.getStream();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._watchdog + "," + this._id + "]";
    }

    class WatchdogProcessLogThread
    implements Runnable {
        private InputStream _is;
        private WriteStream _out;

        WatchdogProcessLogThread(InputStream is, WriteStream out) {
            this._is = is;
            this._out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thread = Thread.currentThread();
            thread.setName("watchdog-process-log-" + WatchdogChildProcess.this._pid + "-" + WatchdogChildProcess.this._id);
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            WriteStream out = this._out;
            try {
                int len;
                byte[] data = new byte[4096];
                while ((len = this._is.read(data, 0, data.length)) > 0) {
                    out.write(data, 0, len);
                    out.flush();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                block22: {
                    try {
                        if (WatchdogChildProcess.this._watchdog.isConsole()) break block22;
                        WriteStream len = out;
                        synchronized (len) {
                            out.close();
                        }
                    }
                    catch (IOException e) {}
                }
                WatchdogChildProcess.this.kill();
            }
        }
    }
}

