/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.util.L10N;

public abstract class WebAppCommand
extends AbstractRepositoryCommand {
    private static final L10N L = new L10N(WebAppCommand.class);

    protected void initBootOptions() {
        this.addValueOption("host", "host", "virtual host to make application available on");
        this.addValueOption("stage", "stage", "stage to deploy application to, defaults to production");
        this.addValueOption("version", "version", "version of application formatted as <major.minor.micro.qualifier>");
        super.initBootOptions();
    }

    public final int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        String tag = args.getArg("-tag");
        if (tag == null) {
            String host;
            String name = this.getName(args, null);
            String stage = args.getArg("-stage");
            if (stage == null) {
                stage = "production";
            }
            if ((host = args.getArg("-host")) == null) {
                host = "default";
            }
            String version = args.getArg("-version");
            tag = stage + "/webapp/" + host + "/" + name;
            if (version != null) {
                tag = tag + "-" + version;
            }
        }
        return this.doCommand(deployClient, tag);
    }

    protected abstract int doCommand(WebAppDeployClient var1, String var2);
}

