/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import java.io.IOException;

public class FloatConstant
extends ConstantPoolEntry {
    private float _value;

    FloatConstant(ConstantPool pool, int index, float value) {
        super(pool, index);
        this._value = value;
    }

    public float getValue() {
        return this._value;
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(4);
        out.writeFloat(this._value);
    }

    public int export(ConstantPool target) {
        return target.addFloat(this._value).getIndex();
    }

    public String toString() {
        return "FloatConstant[" + this._value + "]";
    }
}

