/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.loadbalance;

import com.caucho.cloud.loadbalance.LoadBalanceManager;
import com.caucho.cloud.loadbalance.LoadBalanceStrategy;
import com.caucho.cloud.loadbalance.SingleLoadBalanceManager;
import com.caucho.cloud.loadbalance.StickyRequestHashGenerator;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.config.ConfigException;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalanceBuilder {
    private static final L10N L = new L10N(LoadBalanceBuilder.class);
    private LoadBalanceStrategy _strategy = LoadBalanceStrategy.ADAPTIVE;
    private String _meterCategory = null;
    private long _idleTimeout;
    private ArrayList<ClientSocketFactory> _clientList = new ArrayList();
    private String _cluster;
    private int _port;

    public void setStrategy(LoadBalanceStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        this._strategy = strategy;
    }

    public LoadBalanceStrategy getStrategy() {
        return this._strategy;
    }

    public void setStickyRequestHashGenerator(StickyRequestHashGenerator gen) {
    }

    public void setIdleTimeout(long timeout) {
        this._idleTimeout = timeout;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setMeterCategory(String category) {
        this._meterCategory = category;
    }

    public String getMeterCategory() {
        return this._meterCategory;
    }

    public void addAddress(String address) {
        ClientSocketFactory client = this.createClientSocketFactory(address);
        this.addClient(client);
    }

    public void addClient(ClientSocketFactory client) {
        client.init();
        client.start();
        this._clientList.add(client);
    }

    public ArrayList<ClientSocketFactory> getClientList() {
        return this._clientList;
    }

    public void setTargetCluster(String clusterId) {
        throw new IllegalStateException(L.l("{0}: setTargetCluster requires Resin Professional.", (Object)this));
    }

    public void setTargetPort(int port) {
        throw new IllegalStateException(L.l("{0}: setTargetPort requires Resin Professional.", (Object)this));
    }

    public void setTargetCluster(CloudPod pod) {
        throw new IllegalStateException(L.l("{0}: setTargetCluster requires Resin Professional.", (Object)this));
    }

    public LoadBalanceManager create() {
        ClientSocketFactory socketFactory = null;
        if (this.getClientList().size() > 0) {
            socketFactory = this.getClientList().get(0);
        }
        return new SingleLoadBalanceManager(socketFactory, this.getMeterCategory());
    }

    protected ClientSocketFactory createClientSocketFactory(String address) {
        int p = address.lastIndexOf(58);
        int q = address.lastIndexOf(93);
        if (p < 0 && q < p) {
            throw new ConfigException(L.l("'{0}' is an invalid address because it does not specify the port.", (Object)address));
        }
        String host = address.substring(0, p);
        int port = Integer.parseInt(address.substring(p + 1));
        ServletService server = ServletService.getCurrent();
        boolean isSecure = false;
        ClientSocketFactory factory = new ClientSocketFactory(server.getServerId(), address, this.getMeterCategory(), address, host, port, isSecure);
        if (this._idleTimeout > 0L) {
            factory.setLoadBalanceIdleTime(this._idleTimeout);
        }
        return factory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

