/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.bam.mailbox.DualSizeMailbox;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.network.balance.ClientSocketFactory;
import java.util.Date;

public class ClusterServerAdmin
extends AbstractManagedObject
implements ClusterServerMXBean {
    private final ClusterServer _server;

    public ClusterServerAdmin(ClusterServer server) {
        this._server = server;
    }

    public String getName() {
        return this._server.getId();
    }

    public String getType() {
        return "ClusterServer";
    }

    public ClusterMXBean getCluster() {
        return this._server.getCluster().getAdmin();
    }

    public int getClusterIndex() {
        return this._server.getIndex();
    }

    public String getAddress() {
        return this._server.getAddress();
    }

    public int getPort() {
        return this._server.getPort();
    }

    public boolean isDynamicServer() {
        return this._server.isDynamic();
    }

    public boolean isTriadServer() {
        return this._server.isTriad();
    }

    public boolean isSelfServer() {
        return this._server.isSelf();
    }

    public long getRecoverTime() {
        return this._server.getLoadBalanceRecoverTime();
    }

    public long getIdleTime() {
        return this._server.getLoadBalanceIdleTime();
    }

    public int getConnectionMin() {
        return this._server.getLoadBalanceConnectionMin();
    }

    public long getConnectTimeout() {
        return this._server.getLoadBalanceConnectTimeout();
    }

    public long getSocketTimeout() {
        return this._server.getLoadBalanceSocketTimeout();
    }

    public long getClusterIdleTime() {
        return this._server.getClusterIdleTime();
    }

    public long getWarmupTime() {
        return this._server.getLoadBalanceWarmupTime();
    }

    public int getWeight() {
        return this._server.getLoadBalanceWeight();
    }

    public String getClusterState() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getState();
        }
        return "self";
    }

    public String getLoadBalanceState() {
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            return pool.getState();
        }
        return "self";
    }

    public boolean isHeartbeatActive() {
        return this._server.isHeartbeatActive();
    }

    public String getHeartbeatState() {
        return this._server.getHeartbeatState();
    }

    public Date getLastHeartbeatTime() {
        long lastHeartbeatTime = this._server.getLastHeartbeatTime();
        if (lastHeartbeatTime > 0L) {
            return new Date(lastHeartbeatTime);
        }
        return null;
    }

    public int getConnectionActiveCount() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getActiveCount();
        }
        return 0;
    }

    public int getConnectionIdleCount() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getIdleCount();
        }
        return 0;
    }

    public long getConnectionNewCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getConnectCountTotal();
        }
        return 0L;
    }

    public long getConnectionFailCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getFailCountTotal();
        }
        return 0L;
    }

    public Date getLastFailTime() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getLastFailTime();
        }
        return null;
    }

    public Date getLastSuccessTime() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return new Date(pool.getLastSuccessTime());
        }
        return null;
    }

    public double getLatencyFactor() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getLatencyFactor();
        }
        return 0.0;
    }

    public long getConnectionBusyCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getBusyCountTotal();
        }
        return 0L;
    }

    public Date getLastBusyTime() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getLastBusyTime();
        }
        return null;
    }

    public long getConnectionKeepaliveCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getKeepaliveCountTotal();
        }
        return 0L;
    }

    public double getServerCpuLoadAvg() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getCpuLoadAvg();
        }
        return 0.0;
    }

    public int getMessageQueueSize() {
        DualSizeMailbox mbox = this._server.getCloudServer().getData(DualSizeMailbox.class);
        if (mbox != null) {
            return mbox.getSmallQueueSize();
        }
        return -1;
    }

    public int getMessageQueueLargeSize() {
        DualSizeMailbox mbox = this._server.getCloudServer().getData(DualSizeMailbox.class);
        if (mbox != null) {
            return mbox.getLargeQueueSize();
        }
        return -1;
    }

    public void start() {
        this._server.getCloudServer().enable();
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            pool.start();
        }
    }

    public void stop() {
        this._server.getCloudServer().disable();
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            pool.stop();
        }
    }

    public void enableSessionOnly() {
        this._server.getCloudServer().disableSoft();
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            pool.enableSessionOnly();
        }
    }

    public boolean ping() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.canConnect();
        }
        return true;
    }

    public void removeDynamicServer() {
    }

    protected void register() {
        this.registerSelf();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

