/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.core;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.annotation.NoAspect;
import com.caucho.config.core.ResinControl;
import com.caucho.config.type.FlowBean;
import com.caucho.config.types.FileSetType;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@NoAspect
public class ResinImport
extends ResinControl
implements FlowBean {
    private static final L10N L = new L10N(ResinImport.class);
    private static final Logger log = Logger.getLogger(ResinImport.class.getName());
    private Path _path;
    private FileSetType _fileSet;
    private boolean _isOptional;
    private boolean _isRecover;

    public void setPath(Path path) {
        if (path == null) {
            throw new NullPointerException(L.l("'path' may not be null for resin:import"));
        }
        this._path = path;
    }

    public void setFileset(FileSetType fileSet) {
        this._fileSet = fileSet;
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    public void setRecover(boolean isRecover) {
        this._isRecover = isRecover;
    }

    @PostConstruct
    public void init() throws Exception {
        this.initImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initImpl() throws Exception {
        ArrayList<Path> paths;
        if (this._path == null) {
            if (this._fileSet == null) {
                throw new ConfigException(L.l("'path' attribute missing from resin:import."));
            }
        } else if (!this._path.canRead() || this._path.isDirectory()) {
            if (this._isOptional && !this._path.exists()) {
                log.finer(L.l("resin:import '{0}' is not readable.", (Object)this._path));
                Environment.addDependency(new Depend(this._path));
                return;
            }
            throw new ConfigException(L.l("Required file '{0}' can not be read for resin:import.", (Object)this._path.getNativePath()));
        }
        Object object = this.getObject();
        String schema = null;
        if (object instanceof SchemaBean) {
            schema = ((SchemaBean)object).getSchema();
        }
        if (this._fileSet != null) {
            paths = this._fileSet.getPaths();
            for (Path root : this._fileSet.getRoots()) {
                Environment.addDependency(new Depend(root));
            }
        } else {
            paths = new ArrayList();
            paths.add(this._path);
        }
        int i = 0;
        while (true) {
            block21: {
                if (i >= paths.size()) {
                    return;
                }
                Path path = paths.get(i);
                if (!path.isDirectory()) {
                    Object var10_12;
                    log.config(L.l("resin:import '{0}'", (Object)path.getNativePath()));
                    Environment.addDependency(new Depend(path));
                    String recoverAttr = "resin.config.recoverable";
                    Object oldRecover = Config.getCurrentVar(recoverAttr);
                    try {
                        try {
                            Config.setProperty(recoverAttr, this._isRecover);
                            Config config = new Config();
                            config.configureBean(object, path, schema);
                        }
                        catch (ConnectException e) {
                            if (!this._isOptional) {
                                throw e;
                            }
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, e.toString(), e);
                            } else {
                                log.fine(path + ": " + e);
                            }
                            var10_12 = null;
                            Config.setProperty(recoverAttr, oldRecover);
                            break block21;
                        }
                        catch (RuntimeException e) {
                            if (!this._isRecover) {
                                throw e;
                            }
                            log.log(Level.WARNING, e.toString(), e);
                            Environment.setConfigException(e);
                            var10_12 = null;
                            Config.setProperty(recoverAttr, oldRecover);
                            break block21;
                        }
                        var10_12 = null;
                    }
                    catch (Throwable throwable) {
                        var10_12 = null;
                        Config.setProperty(recoverAttr, oldRecover);
                        throw throwable;
                    }
                    Config.setProperty(recoverAttr, oldRecover);
                }
            }
            ++i;
        }
    }
}

