/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.CacheFactory;
import com.caucho.config.util.CacheKeyGeneratorImpl;
import com.caucho.config.util.CacheKeyImpl;
import com.caucho.config.util.CacheUtil;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.cache.Cache;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyParam;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheRemoveEntry;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class CacheGenerator<X>
extends AbstractAspectGenerator<X> {
    private static final L10N L = new L10N(CacheGenerator.class);
    private CacheResult _cacheResult;
    private CachePut _cachePut;
    private CacheRemoveEntry _cacheRemove;
    private CacheRemoveAll _cacheRemoveAll;
    private Class<?> _keyGenerator = CacheKeyGenerator.class;
    private Class<?> _cacheResolver = CacheResolverFactory.class;
    private String _cacheName;
    private String _cacheInstance;
    private String _keyGenInstance;

    public CacheGenerator(CacheFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next, CacheResult cacheResult, CachePut cachePut, CacheRemoveEntry cacheRemove, CacheRemoveAll cacheRemoveAll) {
        super(factory, method, next);
        this._cacheResult = cacheResult;
        this._cachePut = cachePut;
        this._cacheRemove = cacheRemove;
        this._cacheRemoveAll = cacheRemoveAll;
        if (this._cacheResult != null) {
            this._cacheName = this._cacheResult.cacheName();
            this._keyGenerator = this._cacheResult.cacheKeyGenerator();
            this._cacheResolver = this._cacheResult.cacheResolverFactory();
        } else if (this._cachePut != null) {
            this._cacheName = this._cachePut.cacheName();
            this._keyGenerator = this._cachePut.cacheKeyGenerator();
            this._cacheResolver = this._cachePut.cacheResolverFactory();
        } else if (this._cacheRemove != null) {
            this._cacheName = this._cacheRemove.cacheName();
            this._keyGenerator = this._cacheRemove.cacheKeyGenerator();
            this._cacheResolver = this._cacheRemove.cacheResolverFactory();
        } else if (this._cacheRemoveAll != null) {
            this._cacheName = this._cacheRemoveAll.cacheName();
            this._cacheResolver = this._cacheRemoveAll.cacheResolverFactory();
        } else {
            throw new IllegalStateException();
        }
        CacheDefaults cacheDefaults = method.getDeclaringType().getAnnotation(CacheDefaults.class);
        if (cacheDefaults != null) {
            if ("".equals(this._cacheName)) {
                this._cacheName = cacheDefaults.cacheName();
            }
            if (CacheKeyGenerator.class.equals(this._keyGenerator)) {
                this._keyGenerator = cacheDefaults.cacheKeyGenerator();
            }
            if (CacheResolverFactory.class.equals(this._cacheResolver)) {
                this._cacheResolver = cacheDefaults.cacheResolverFactory();
            }
        }
        if ("".equals(this._cacheName)) {
            Method javaMethod = method.getJavaMember();
            this._cacheName = javaMethod.getDeclaringClass().getName() + "." + javaMethod.getName();
        }
        if (CacheKeyGenerator.class.equals(this._keyGenerator)) {
            this._keyGenerator = null;
        }
        if (CacheResolverFactory.class.equals(this._cacheResolver)) {
            this._cacheResolver = null;
        }
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateMethodPrologue(out, map);
        this._cacheInstance = "__caucho_cache_" + out.generateId();
        out.println();
        out.println("private static final javax.cache.Cache " + this._cacheInstance);
        out.print("  = com.caucho.config.util.CacheUtil.getCache(\"");
        out.printJavaString(this._cacheName);
        out.print("\");");
        if (this._keyGenerator != null || this._cacheResolver != null) {
            this._keyGenInstance = "__caucho_cache_key_" + out.generateId();
            out.println();
            out.println("private static final " + CacheKeyGeneratorImpl.class.getName() + " " + this._keyGenInstance);
            out.print(" = new " + CacheKeyGeneratorImpl.class.getName() + "(");
            if (this._keyGenerator != null) {
                out.print("new " + this._keyGenerator.getName() + "()");
            } else {
                out.print("null");
            }
            if (this._cacheResolver != null) {
                out.print(", new " + this._cacheResolver.getName() + "()");
            } else {
                out.print(", null");
            }
            out.print(", \"");
            out.printJavaString(this._cacheName);
            out.print("\"");
            out.print(", " + this.getJavaClass().getName() + ".class");
            Method method = this.getJavaMethod();
            out.print(",\"");
            out.printJavaString(method.getName());
            out.print("\"");
            for (Class<?> param : method.getParameterTypes()) {
                out.print(",");
                out.printClass(param);
                out.print(".class");
            }
            out.println(");");
        }
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
        out.println(Cache.class.getName() + " caucho_cache = " + this._cacheInstance + ";");
        this.buildCacheResolver(out);
        this.buildCacheKey(out);
        if (this._cacheResult != null && !this._cacheResult.skipGet()) {
            out.println("Object cacheValue = caucho_cache.get(candiCacheKey);");
            out.println("if (cacheValue != null) {");
            out.print("  return (");
            out.printClass(this.getJavaMethod().getReturnType());
            out.println(") cacheValue;");
            out.println("}");
        }
        if (this._cachePut != null && !this._cachePut.afterInvocation()) {
            AnnotatedParameter<?> value = this.getCacheValueParam();
            if (value == null) {
                throw new ConfigException(L.l("@CachePut requires a @CacheValue"));
            }
            out.println("caucho_cache.put(candiCacheKey, a" + value.getPosition() + ");");
        }
        if (this._cacheRemove != null && !this._cacheRemove.afterInvocation()) {
            out.println("caucho_cache.remove(candiCacheKey);");
        }
        super.generatePreCall(out);
    }

    @Override
    public void generatePostCall(JavaWriter out) throws IOException {
        super.generatePostCall(out);
        if (this._cacheResult != null) {
            out.println("caucho_cache.put(candiCacheKey, result);");
        }
        if (this._cachePut != null && this._cachePut.afterInvocation()) {
            AnnotatedParameter<?> value = this.getCacheValueParam();
            if (value == null) {
                throw new ConfigException(L.l("@CachePut requires a @CacheValue"));
            }
            out.println("caucho_cache.put(candiCacheKey, a" + value.getPosition() + ");");
        }
        if (this._cacheRemove != null && this._cacheRemove.afterInvocation()) {
            out.println("caucho_cache.remove(candiCacheKey);");
        }
        if (this._cacheRemoveAll != null) {
            out.println("caucho_cache.removeAll();");
        }
    }

    private void buildCacheResolver(JavaWriter out) throws IOException {
        if (this._cacheResolver == null) {
            return;
        }
        out.print("caucho_cache = " + this._keyGenInstance + ".resolveCache(");
        out.print("caucho_cache, ");
        out.print(this.getInstanceName());
        List<AnnotatedParameter<?>> params = this.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            out.print(", ");
            out.print("a" + i);
        }
        out.println(");");
    }

    private void buildCacheKey(JavaWriter out) throws IOException {
        out.println();
        out.println(CacheKey.class.getName() + " candiCacheKey");
        if (this._keyGenInstance != null) {
            out.print(" = " + this._keyGenInstance + ".generateKey(");
            out.print(this.getInstanceName());
            List<AnnotatedParameter<?>> params = this.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                out.print(", ");
                out.print("a" + i);
            }
            out.println(");");
        } else {
            out.print("  = new " + CacheKeyImpl.class.getName() + "(");
            List<AnnotatedParameter<?>> params = this.getMethod().getParameters();
            boolean isCacheKeyParam = this.isCacheKeyParam(params);
            boolean isFirst = true;
            for (int i = 0; i < params.size(); ++i) {
                AnnotatedParameter<?> param = params.get(i);
                if (param.isAnnotationPresent(CacheValue.class) || isCacheKeyParam && !param.isAnnotationPresent(CacheKeyParam.class)) continue;
                if (!isFirst) {
                    out.print(", ");
                }
                out.print("a" + i);
                isFirst = false;
            }
            out.println(");");
        }
    }

    private void buildInvocationContext(JavaWriter out) throws IOException {
        out.print(CacheUtil.class.getName() + ".generateKeyContext(");
        out.print(")");
    }

    private boolean isCacheKeyParam(List<AnnotatedParameter<?>> params) {
        for (AnnotatedParameter<?> param : params) {
            if (!param.isAnnotationPresent(CacheKeyParam.class)) continue;
            return true;
        }
        return false;
    }

    private AnnotatedParameter<?> getCacheValueParam() {
        for (AnnotatedParameter<?> param : this.getParameters()) {
            if (!param.isAnnotationPresent(CacheValue.class)) continue;
            return param;
        }
        return null;
    }

    private List<AnnotatedParameter<?>> getParameters() {
        return this.getMethod().getParameters();
    }
}

