/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.XaCallback;
import com.caucho.config.gen.XaFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.ejb.MessageDriven;
import javax.ejb.SessionSynchronization;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class XaGenerator<X>
extends AbstractAspectGenerator<X> {
    private TransactionAttributeType _transactionType;
    private boolean _isContainerManaged = true;
    private boolean _isSessionSynchronization;

    public XaGenerator(XaFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next, TransactionAttributeType xa, boolean isBeanManaged) {
        super(factory, method, next);
        this._transactionType = xa;
        this._isContainerManaged = !isBeanManaged;
        Class javaClass = factory.getBeanType().getJavaClass();
        this._isSessionSynchronization = SessionSynchronization.class.isAssignableFrom(javaClass);
    }

    public TransactionAttributeType getTransactionType() {
        return this._transactionType;
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (map.get("caucho.ejb.xa") == null) {
            map.put("caucho.ejb.xa", "done");
            out.println();
            out.println("private static final com.caucho.ejb.util.XAManager _xa");
            out.println("  = new com.caucho.ejb.util.XAManager();");
        }
        super.generateMethodPrologue(out, map);
    }

    boolean isEjb() {
        return this.getBeanType().isAnnotationPresent(Stateless.class) || this.getBeanType().isAnnotationPresent(Stateful.class) || this.getBeanType().isAnnotationPresent(Singleton.class) || this.getBeanType().isAnnotationPresent(MessageDriven.class);
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        out.println();
        out.println("boolean isXAValid = false;");
        if (!this._isContainerManaged) {
            out.println();
            out.println("Transaction xa = null;");
        } else if (this._transactionType != null) {
            switch (this._transactionType) {
                case NOT_SUPPORTED: 
                case REQUIRED: 
                case REQUIRES_NEW: {
                    out.println();
                    out.println("Transaction xa = null;");
                    break;
                }
                case MANDATORY: {
                    out.println();
                    out.println("_xa.beginMandatory();");
                    break;
                }
                case SUPPORTS: {
                    out.println();
                    out.println("_xa.beginSupports();");
                    break;
                }
                case NEVER: {
                    out.println();
                    out.println("_xa.beginNever();");
                }
            }
        }
        super.generatePreTry(out);
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
        if (!this._isContainerManaged) {
            out.println("xa = _xa.beginNotSupported();");
        } else if (this._transactionType != null) {
            switch (this._transactionType) {
                case NOT_SUPPORTED: {
                    out.println();
                    out.println("xa = _xa.beginNotSupported();");
                    break;
                }
                case REQUIRED: {
                    out.println();
                    out.println("xa = _xa.beginRequired();");
                    break;
                }
                case REQUIRES_NEW: {
                    out.println();
                    out.println("xa = _xa.beginRequiresNew();");
                }
            }
        }
        if (this._isContainerManaged && this._isSessionSynchronization) {
            out.print("_xa.registerSynchronization(");
            out.print(this.getBeanFactory().getBeanInstance());
            out.println(");");
        }
        if (this._isContainerManaged && this.getBeanType().isAnnotationPresent(XaCallback.class)) {
            out.print("_xa.registerSynchronization(");
            out.print("new __caucho_synchronization()");
            out.println(");");
        }
        super.generatePreCall(out);
    }

    @Override
    public void generatePostCall(JavaWriter out) throws IOException {
        super.generatePostCall(out);
        out.println("isXAValid = true;");
    }

    @Override
    public void generateApplicationException(JavaWriter out, Class<?> exception) throws IOException {
        super.generateApplicationException(out, exception);
        out.println("isXAValid = true;");
        out.println("_xa.applicationException(e);");
    }

    @Override
    public void generateSystemException(JavaWriter out, Class<?> exn) throws IOException {
        boolean isError = Error.class.isAssignableFrom(exn);
        out.println("if (_xa.systemException(e)) {");
        out.pushDepth();
        if (this.isEjb()) {
            if (!isError) {
                out.println("isXAValid = true;");
            }
            if (this._isContainerManaged) {
                switch (this._transactionType) {
                    case SUPPORTS: {
                        out.println("  _xa.rethrowEjbException(e, _xa.getTransaction() != null);");
                        break;
                    }
                    case REQUIRES_NEW: {
                        out.println("_xa.rethrowEjbException(e, " + isError + ");");
                        break;
                    }
                    case NOT_SUPPORTED: 
                    case NEVER: {
                        out.println("_xa.rethrowEjbException(e, false);");
                        break;
                    }
                    case MANDATORY: {
                        out.println("_xa.rethrowEjbException(e, true);");
                        break;
                    }
                    case REQUIRED: {
                        out.println("_xa.rethrowEjbException(e, xa != null);");
                        break;
                    }
                    default: {
                        out.println("_xa.rethrowEjbException(e, xa != null);");
                        break;
                    }
                }
            } else {
                out.println("_xa.rethrowEjbException(e, false);");
            }
        }
        out.popDepth();
        out.println("} else {");
        out.println("  isXAValid = true;");
        out.println("}");
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
        super.generateFinally(out);
        out.println("if (! isXAValid)");
        out.println("  _xa.markRollback();");
        if (!this._isContainerManaged) {
            out.println("if (_xa.getTransaction() != null)");
            out.println("  _xa.commit();");
            out.println("if (xa != null)");
            out.println("  _xa.resume(xa);");
        } else if (this._transactionType != null) {
            switch (this._transactionType) {
                case NOT_SUPPORTED: {
                    out.println("if (xa != null)");
                    out.pushDepth();
                    out.println("  _xa.resume(xa);");
                    out.popDepth();
                    break;
                }
                case REQUIRED: {
                    out.println("if (xa == null)");
                    out.pushDepth();
                    out.println("_xa.commit();");
                    out.popDepth();
                    break;
                }
                case REQUIRES_NEW: {
                    out.println("_xa.endRequiresNew(xa);");
                    out.println("if (! isXAValid)");
                    out.println("  _xa.markRollback();");
                }
            }
        }
    }
}

