/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.QualifierBinding;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Decorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class DecoratorEntry<X> {
    private Decorator<X> _decorator;
    private ArrayList<QualifierBinding> _bindings = new ArrayList();
    private BaseType _delegateType;
    private boolean _isEnabled;
    private Set<BaseType> _decoratedTypes = new LinkedHashSet<BaseType>();

    public DecoratorEntry(InjectManager manager, Decorator<X> decorator, BaseType delegateType) {
        this._decorator = decorator;
        this._delegateType = delegateType;
        for (Annotation ann : decorator.getDelegateQualifiers()) {
            this._bindings.add(new QualifierBinding(ann));
        }
        if (this._bindings.size() == 0) {
            this._bindings.add(new QualifierBinding(DefaultLiteral.DEFAULT));
        }
        for (Type type : decorator.getDecoratedTypes()) {
            this._decoratedTypes.add(manager.createSourceBaseType(type));
        }
    }

    public Decorator<X> getDecorator() {
        return this._decorator;
    }

    public BaseType getDelegateType() {
        return this._delegateType;
    }

    public Set<BaseType> getDecoratedTypes() {
        return this._decoratedTypes;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
    }

    public boolean isMatch(Annotation[] bindingAnn) {
        if (!this._isEnabled) {
            return false;
        }
        for (QualifierBinding binding : this._bindings) {
            if (this.isMatch(binding, bindingAnn)) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(QualifierBinding binding, Annotation[] bindingAnn) {
        for (Annotation ann : bindingAnn) {
            if (!binding.isMatch(ann)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._decorator + "]";
    }
}

